Imports System.Data.SqlClient

Public Class Tester

    Public Sub OnRowUpdated(ByVal sender As Object, ByVal e As SqlRowUpdatedEventArgs)

        ' Sprawdzanie, czy jakiekolwiek rekordy zostay zmienione.
        ' Jeli nie, instrukcja nie zostaa wykonana zgodnie
        ' z oczekiwaniamia.
        If e.RecordsAffected() < 1 Then
            ' Sprawdzanie typu bdu.
            Select Case e.StatementType
                Case StatementType.Delete
                    lblResult.Text &= "Nie usunito (ProductName: "
                Case StatementType.Insert
                    lblResult.Text &= "Nie wstawiono (ProductName: "
                Case StatementType.Update
                    lblResult.Text &= "Nie zaktualizowano (ProductName: "
            End Select

            lblResult.Text &= e.Row("ProductName") & ")" & vbNewLine
            lblResult.Text &= "  Dane zostay zmienione przez innego uytkownika."
            lblResult.Text &= vbNewLine

            ' Nakazanie ADO.NET
            ' zignorowania problemu i zaktualizowania pozostaych wierszy. 
            e.Status = UpdateStatus.SkipCurrentRow
        End If

    End Sub


    Private Sub cmdTest_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cmdTest.Click

        lblResult.Text = ""

        ' Definiowanie obiektw ADO.NET.
        Dim SQL As String = "SELECT * FROM Products"
        Dim Connect As String = "Data Source=localhost;Integrated Security=True;" & _
         "Initial Catalog=Northwind;"

        Dim con As New SqlConnection(Connect)
        Dim cmd As New SqlCommand(SQL, con)
        Dim adapter As New SqlDataAdapter(cmd)

        ' Tworzenie obiektu CommandBuilder.
        Dim cb As New SqlCommandBuilder(adapter)
        ' Pobieranie zaktualizowanego obiektu DataAdapter.
        adapter = cb.DataAdapter

        ' Podczanie metody obsugi zdarzenia.
        AddHandler adapter.RowUpdated, AddressOf OnRowUpdated

        ' Tworzenie dwch obiektw DataSet... doskonay sposb na wywoanie konfliktu danych.
        Dim dsNorthwind1 As New DataSet(), dsNorthwind2 As New DataSet()

        Try
            con.Open()

            ' Zapenianie obu obiektw DataSet.
            adapter.Fill(dsNorthwind1, "Products")
            adapter.Fill(dsNorthwind2, "Products")

            ' "Odwrcenie" wartoci pola Discontinued w pierwszym wierszu dsNorthwind1.
            dsNorthwind1.Tables(0).Rows(0).Item("Discontinued") = Not dsNorthwind1.Tables(0).Rows(0).Item("Discontinued")

            ' Aktualizacja bazy danych.
            adapter.Update(dsNorthwind1, "Products")

            ' Wprowadzanie zmian w drugim obiekcie DataSet.
            dsNorthwind2.Tables(0).Rows(0).Item("ProductName") = "Jumbo Sea Monkeys"

            ' Prba aktualizacji tego wiersza. Cho te zmiany nie powoduj konfliktu, 
            ' prba aktualizacji nie powiedzie si, poniewa wiersz zosta zmieniony.
            adapter.Update(dsNorthwind2, "Products")

        Catch err As Exception
            lblResult.Text &= err.Message
        Finally
            con.Close()
        End Try

    End Sub

End Class