Public Class Person

    ' Data for the Person
    Private _FirstName As String
    Private _LastName As String
    Private _BirthDate As Date

    Public Property FirstName() As String
        Get
            Return _FirstName
        End Get

        Set(ByVal Value As String)
            _FirstName = Value
        End Set
    End Property

    Public Property LastName() As String
        Get
            Return _LastName
        End Get

        Set(ByVal Value As String)
            _LastName = Value
        End Set
    End Property

    Public ReadOnly Property BirthDate() As Date
        Get
            Return _BirthDate
        End Get
    End Property

    ' Constructors.
    Public Sub New(ByVal FirstName As String, ByVal LastName As String, _
     ByVal BirthDate As Date)
        _FirstName = FirstName
        _LastName = LastName
        _BirthDate = BirthDate
    End Sub

    Public Sub New(ByVal FirstName As String, ByVal LastName As String)
        _FirstName = FirstName
        _LastName = LastName
        _BirthDate = DateTime.Now
    End Sub

    Public Sub New(ByVal FirstName As String, ByVal LastName As String, _
     ByVal Age As Integer)
        _FirstName = FirstName
        _LastName = LastName
        _BirthDate = DateTime.Now.AddYears(-Age)
    End Sub

    ' Built-in feature to get the Person object to introduce itself.
    Public Function GetIntroduction() As String
        Dim Intro As String
        Intro = "My name is " & FirstName & " " & LastName & ". "
        Intro &= "I was born on " & BirthDate.ToString
        Return Intro
    End Function

End Class

Public Class NuclearFamily
    Public Father As Person
    Public Mother As Person
    Public Children As New Collection()

    Public Sub New(ByVal Father As Person, ByVal Mother As Person)
        Me.Father = Father
        Me.Mother = Mother
    End Sub

    Public Sub New()
    End Sub

    Public Function FindYoungestChild() As Person
        Dim Child As Person
        Dim Youngest As Person = Nothing

        For Each Child In Children
            If Youngest Is Nothing Then
                Youngest = Child
            ElseIf Youngest.BirthDate < Child.BirthDate Then
                Youngest = Child
            End If
        Next

        Return Youngest
    End Function

End Class


