Imports System.Drawing.Printing

Public Class Form1

    Private Sub cmdPrint_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cmdPrint.Click
        Dim MyDoc As New PrintDocument()
        AddHandler MyDoc.PrintPage, AddressOf UnWrappedPrint

        Dim dlgSettings As New PrintDialog()
        dlgSettings.Document = MyDoc

        Dim Result As DialogResult
        Result = dlgSettings.ShowDialog()

        If Result = DialogResult.OK Then MyDoc.Print()
    End Sub


    Private Sub cmdPrintWrapped_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cmdPrintWrapped.Click
        Dim MyDoc As New PrintDocument()
        AddHandler MyDoc.PrintPage, AddressOf WrappedPrint

        Dim dlgSettings As New PrintDialog()
        dlgSettings.Document = MyDoc

        Dim Result As DialogResult
        Result = dlgSettings.ShowDialog()

        If Result = DialogResult.OK Then MyDoc.Print()
    End Sub

    Private Sub UnWrappedPrint(ByVal sender As Object, ByVal e As PrintPageEventArgs)

        ' Define the font and determine the line height.
        ' Wybieramy czcionk i okrelamy wysoko wiersza.
        Dim MyFont As New Font("Verdana", 16)

        ' Create varialbes to hold position on page.
        ' Tworzymy znienn do przechowywania pozycji na stronie.
        Dim x As Single = e.MarginBounds.Left
        Dim y As Single = e.MarginBounds.Top

        e.Graphics.DrawString(txtData.Text, MyFont, Brushes.Black, x, y)

    End Sub


    Private Sub WrappedPrint(ByVal sender As Object, ByVal e As PrintPageEventArgs)

        ' Define the font and determine the line height.
        Dim MyFont As New Font("Verdana", 16)

        ' Create varialbes to hold position on page.
        Dim x As Single = e.MarginBounds.Left
        Dim y As Single = e.MarginBounds.Top

        e.Graphics.DrawString(txtData.Text, MyFont, Brushes.Black, _
          e.MarginBounds, StringFormat.GenericDefault)

    End Sub

    Private Sub WrappedPrint2(ByVal sender As Object, ByVal e As PrintPageEventArgs)

        ' Define the font and determine the line height.
        Dim MyFont As New Font("Verdana", 16)
        Dim LineHeight As Single = MyFont.GetHeight(e.Graphics)

        ' Create variables to hold position on page.
        Dim x As Single = e.MarginBounds.Left
        Dim y As Single = e.MarginBounds.Top

        Dim Line As String
        Dim ParsedLines As New ArrayList()
        Dim TextToPrint As String = txtData.Text

        Dim i As Integer


        Do
            ' Dodajemy jeden znak do bieacego wiersza i usuwamy go z wiersza do wydruku.
            Line &= TextToPrint.Chars(0)
            TextToPrint = TextToPrint.Substring(1)

            If Line.EndsWith(" ") Then
                If e.Graphics.MeasureString(Line, MyFont).Width > (e.PageBounds.Width - 300) Then
                    ParsedLines.Add(Line)
                    Line = ""
                End If
            End If
        Loop While TextToPrint <> ""

        ParsedLines.Add(Line)

        For Each Line In ParsedLines
            e.Graphics.DrawString(Line, MyFont, Brushes.Black, x, y)
            y += LineHeight
        Next

    End Sub

    Private Sub Label1_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Label1.Click

    End Sub
End Class
