Imports System.Drawing.Printing

Public Class Form1

    Private WithEvents MyDoc As New PrintDocument()
    Private PageNumber As Integer
    Private Offset As Integer
    Private PrintData(100) As String

    Private Sub PrintStatus_Load(ByVal sender As System.Object, _
      ByVal e As System.EventArgs) Handles MyBase.Load
        ' Fill PrintData array with bogus information.
        ' wypeniamy informacjami macierz danych do druku.
        Dim i As Integer
        For i = 0 To 100
            PrintData(i) = "To wiersz numer " & i + 1 & ". "
            PrintData(i) &= "Pochodzi z elementu macierzy o indeksie "
            PrintData(i) &= i & "."
        Next

    End Sub


    Private Sub cmdPrint_Click(ByVal sender As System.Object, _
      ByVal e As System.EventArgs) Handles cmdPrint.Click
        lblStatus.Text = ""
        PageNumber = 0
        Offset = 0

        Dim dlgSettings As New PrintDialog()
        dlgSettings.Document = MyDoc

        Dim Result As DialogResult
        Result = dlgSettings.ShowDialog()

        If Result = DialogResult.OK Then MyDoc.Print()
    End Sub

    Private Sub MyDoc_PrintPage(ByVal sender As Object, _
     ByVal e As PrintPageEventArgs) Handles MyDoc.PrintPage

        ' Define the font and determine the line height.
        ' Okrelamy czcionk i wysoko wiersza (czcionki).
        Dim MyFont As New Font("Arial", 10)
        Dim LineHeight As Single = MyFont.GetHeight(e.Graphics)

        ' Create variables to hold position on page.
        ' Tworzymy zmienn do przechowywania pozycji na stronie.
        Dim x As Single = e.MarginBounds.Left
        Dim y As Single = e.MarginBounds.Top

        ' Increment global page counter and refresh display.
        ' Inkrementujemy globalny licznik stron i odwieamy ekran.
        PageNumber += 1
        lblStatus.Text &= vbNewLine & "Przesyam na drukark stronic " & PageNumber & " ..."

        ' Print all the information that can fit on the page. 
        ' Drukujemy wszystko, co mieci si na stronie.
        Do
            e.Graphics.DrawString(PrintData(Offset), MyFont, Brushes.Black, x, y)
            Offset += 1
            y += LineHeight
        Loop Until (y + LineHeight) > e.MarginBounds.Bottom Or Offset > PrintData.GetUpperBound(0)

        ' Determine if another page is needed.
        ' Sprawdzamy, czy potrzebna jest nastpna stronica.
        If Offset < PrintData.GetUpperBound(0) Then
            e.HasMorePages = True
        Else
            Offset = 0
            lblStatus.Text &= vbNewLine & "Wydruk podgldu zakoczony."
        End If

    End Sub

    Private Sub cmdPreview_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cmdPreview.Click
        lblStatus.Text = ""

        Dim dlgPreview As New PrintPreviewDialog()
        dlgPreview.Document = MyDoc
        dlgPreview.Show()
    End Sub

    Private Sub cmdPreviewInForm_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cmdPreviewInForm.Click
        lblStatus.Text = ""

        ' The default size zoom is 0.3. 1 is full-size.
        ' Domylne powikszenie (skala) wynosi 0.3. Jedynka to peny rozmiar.
        Preview.Zoom = 0.2

        ' The Rows and Columns settings mean 6 pages can be displayed at once (2 x 3).
        ' Takie zainicjowanie zmiennych Wiersze i Kolumny oznacza, e
        ' jednoczenie mona wywietla 6 stron: (3 x 2)
        Preview.Columns = 2
        Preview.Rows = 3

        Preview.Document = MyDoc

        ' The next line triggers the actual preview.
        ' Uniewanienie - aktualizacja podgldu.
        Preview.InvalidatePreview()


    End Sub

    Private Sub RadioButton1_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles RadioButton1.CheckedChanged, RadioButton4.Click, RadioButton3.Click, RadioButton2.Click, RadioButton1.Click, RadioButton5.CheckedChanged
        Dim ctrl As Control = CType(sender, Control)
        Preview.Zoom = Val(ctrl.Text) / 100
    End Sub
End Class
