Public Class CustomTextBox
    Inherits System.Windows.Forms.TextBox

    ' Override the OnKeyPress method, which fires whenever
    ' a key is pressed.
    Protected Overrides Sub OnKeyPress(ByVal e As KeyPressEventArgs)
        ' Call the base method (which raises the KeyPress event).
        MyBase.OnKeyPress(e)

        ' Check if the just-typed character is numeric
        ' or a control character (like backspace).
        If Char.IsControl(e.KeyChar) = False And _
          Char.IsDigit(e.KeyChar) = False Then
            ' If it isn't, set the Handled property to
            ' tell the TextBox to ignore this keypress.
            e.Handled = True
        End If
    End Sub
End Class
