﻿Imports System.Data.Common
Imports System.Configuration

Module GenericDatabaseTest

    Public Sub Main()

        ' Pobieranie wszystkich informacji z pliku konfiguracyjnego.
        Dim Factory, Connection, Query As String
        Factory = ConfigurationManager.AppSettings("Factory")
        Connection = ConfigurationManager.AppSettings("Connection")
        Query = ConfigurationManager.AppSettings("Query")

        ' Pobieranie obiektu fabrycznego dla dostawcy.
        Dim Provider As DbProviderFactory
        Provider = DbProviderFactories.GetFactory(Factory)

        ' Używanie obiektu fabrycznego do utworzenia połączenia.
        Dim con As DbConnection = Provider.CreateConnection()
        con.ConnectionString = Connection

        ' Używanie obiektu fabrycznego do utworzenia obiektu DataAdapter
        ' i zapełnienie obiektu DataSet.
        Dim Adapter As DbDataAdapter = Provider.CreateDataAdapter
        Adapter.SelectCommand = Provider.CreateCommand()
        Adapter.SelectCommand.Connection = con
        Adapter.SelectCommand.CommandText = Query
        Dim ds As New DataSet
        Adapter.Fill(ds, "Orders")

        ' Wyświetlanie pobranych informacji.
        For Each Row As DataRow In ds.Tables("Orders").Rows
            Console.WriteLine(Row("OrderID"))
        Next

        Console.ReadLine()
    End Sub

End Module
