Public Class ControlPanelForm
    Inherits System.Windows.Forms.Form

#Region " Windows Form Designer generated code "

    Public Sub New()
        MyBase.New()

        'This call is required by the Windows Form Designer.
        InitializeComponent()

        'Add any initialization after the InitializeComponent() call

    End Sub

    'Form overrides dispose to clean up the component list.
    Protected Overloads Overrides Sub Dispose(ByVal disposing As Boolean)
        If disposing Then
            If Not (components Is Nothing) Then
                components.Dispose()
            End If
        End If
        MyBase.Dispose(disposing)
    End Sub
    Friend WithEvents txtClassCode As System.Windows.Forms.TextBox
    Friend WithEvents lblCodeCaption As System.Windows.Forms.Label
    Friend WithEvents GroupBox1 As System.Windows.Forms.GroupBox
    Friend WithEvents txtFirst As System.Windows.Forms.TextBox
    Friend WithEvents cmdUpdate As System.Windows.Forms.Button
    Friend WithEvents cmdRelease As System.Windows.Forms.Button
    Friend WithEvents cmdCreate As System.Windows.Forms.Button
    Friend WithEvents dtBirth As System.Windows.Forms.DateTimePicker
    Friend WithEvents txtLast As System.Windows.Forms.TextBox
    Friend WithEvents Label1 As System.Windows.Forms.Label
    Friend WithEvents Label2 As System.Windows.Forms.Label
    Friend WithEvents Label3 As System.Windows.Forms.Label
    Friend WithEvents txtIntro As System.Windows.Forms.TextBox
    Friend WithEvents cmdGetIntro As System.Windows.Forms.Button
    Friend WithEvents cmdClose As System.Windows.Forms.Button

    'Required by the Windows Form Designer
    Private components As System.ComponentModel.Container

    'NOTE: The following procedure is required by the Windows Form Designer
    'It can be modified using the Windows Form Designer.  
    'Do not modify it using the code editor.
    <System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()
        Dim resources As System.ComponentModel.ComponentResourceManager = New System.ComponentModel.ComponentResourceManager(GetType(ControlPanelForm))
        Me.GroupBox1 = New System.Windows.Forms.GroupBox
        Me.Label3 = New System.Windows.Forms.Label
        Me.Label1 = New System.Windows.Forms.Label
        Me.cmdRelease = New System.Windows.Forms.Button
        Me.cmdGetIntro = New System.Windows.Forms.Button
        Me.cmdCreate = New System.Windows.Forms.Button
        Me.txtIntro = New System.Windows.Forms.TextBox
        Me.Label2 = New System.Windows.Forms.Label
        Me.cmdUpdate = New System.Windows.Forms.Button
        Me.txtLast = New System.Windows.Forms.TextBox
        Me.dtBirth = New System.Windows.Forms.DateTimePicker
        Me.txtFirst = New System.Windows.Forms.TextBox
        Me.txtClassCode = New System.Windows.Forms.TextBox
        Me.lblCodeCaption = New System.Windows.Forms.Label
        Me.cmdClose = New System.Windows.Forms.Button
        Me.GroupBox1.SuspendLayout()
        Me.SuspendLayout()
        '
        'GroupBox1
        '
        Me.GroupBox1.Anchor = CType(((System.Windows.Forms.AnchorStyles.Top Or System.Windows.Forms.AnchorStyles.Bottom) _
                    Or System.Windows.Forms.AnchorStyles.Left), System.Windows.Forms.AnchorStyles)
        Me.GroupBox1.Controls.Add(Me.Label3)
        Me.GroupBox1.Controls.Add(Me.Label1)
        Me.GroupBox1.Controls.Add(Me.cmdRelease)
        Me.GroupBox1.Controls.Add(Me.cmdGetIntro)
        Me.GroupBox1.Controls.Add(Me.cmdCreate)
        Me.GroupBox1.Controls.Add(Me.txtIntro)
        Me.GroupBox1.Controls.Add(Me.Label2)
        Me.GroupBox1.Controls.Add(Me.cmdUpdate)
        Me.GroupBox1.Controls.Add(Me.txtLast)
        Me.GroupBox1.Controls.Add(Me.dtBirth)
        Me.GroupBox1.Controls.Add(Me.txtFirst)
        Me.GroupBox1.Location = New System.Drawing.Point(8, 16)
        Me.GroupBox1.Name = "GroupBox1"
        Me.GroupBox1.Size = New System.Drawing.Size(318, 268)
        Me.GroupBox1.TabIndex = 4
        Me.GroupBox1.TabStop = False
        Me.GroupBox1.Text = "Control Panel"
        '
        'Label3
        '
        Me.Label3.Location = New System.Drawing.Point(12, 92)
        Me.Label3.Name = "Label3"
        Me.Label3.Size = New System.Drawing.Size(36, 12)
        Me.Label3.TabIndex = 4
        Me.Label3.Text = "Data:"
        '
        'Label1
        '
        Me.Label1.Location = New System.Drawing.Point(12, 36)
        Me.Label1.Name = "Label1"
        Me.Label1.Size = New System.Drawing.Size(36, 12)
        Me.Label1.TabIndex = 4
        Me.Label1.Text = "Imi:"
        '
        'cmdRelease
        '
        Me.cmdRelease.Enabled = False
        Me.cmdRelease.Location = New System.Drawing.Point(214, 56)
        Me.cmdRelease.Name = "cmdRelease"
        Me.cmdRelease.Size = New System.Drawing.Size(88, 23)
        Me.cmdRelease.TabIndex = 4
        Me.cmdRelease.Text = "Kasuj"
        '
        'cmdGetIntro
        '
        Me.cmdGetIntro.Enabled = False
        Me.cmdGetIntro.Location = New System.Drawing.Point(12, 148)
        Me.cmdGetIntro.Name = "cmdGetIntro"
        Me.cmdGetIntro.Size = New System.Drawing.Size(112, 23)
        Me.cmdGetIntro.TabIndex = 6
        Me.cmdGetIntro.Text = "Przedstaw si:->"
        '
        'cmdCreate
        '
        Me.cmdCreate.Location = New System.Drawing.Point(214, 31)
        Me.cmdCreate.Name = "cmdCreate"
        Me.cmdCreate.Size = New System.Drawing.Size(88, 23)
        Me.cmdCreate.TabIndex = 3
        Me.cmdCreate.Text = "Utwrz"
        '
        'txtIntro
        '
        Me.txtIntro.Location = New System.Drawing.Point(147, 148)
        Me.txtIntro.Multiline = True
        Me.txtIntro.Name = "txtIntro"
        Me.txtIntro.ReadOnly = True
        Me.txtIntro.ScrollBars = System.Windows.Forms.ScrollBars.Vertical
        Me.txtIntro.Size = New System.Drawing.Size(155, 68)
        Me.txtIntro.TabIndex = 6
        '
        'Label2
        '
        Me.Label2.Location = New System.Drawing.Point(12, 64)
        Me.Label2.Name = "Label2"
        Me.Label2.Size = New System.Drawing.Size(64, 12)
        Me.Label2.TabIndex = 4
        Me.Label2.Text = "Nazwisko:"
        '
        'cmdUpdate
        '
        Me.cmdUpdate.Enabled = False
        Me.cmdUpdate.Location = New System.Drawing.Point(214, 87)
        Me.cmdUpdate.Name = "cmdUpdate"
        Me.cmdUpdate.Size = New System.Drawing.Size(88, 23)
        Me.cmdUpdate.TabIndex = 5
        Me.cmdUpdate.Text = "Aktualizuj"
        '
        'txtLast
        '
        Me.txtLast.Location = New System.Drawing.Point(82, 58)
        Me.txtLast.Name = "txtLast"
        Me.txtLast.Size = New System.Drawing.Size(112, 21)
        Me.txtLast.TabIndex = 1
        '
        'dtBirth
        '
        Me.dtBirth.Format = System.Windows.Forms.DateTimePickerFormat.[Short]
        Me.dtBirth.Location = New System.Drawing.Point(82, 85)
        Me.dtBirth.Name = "dtBirth"
        Me.dtBirth.Size = New System.Drawing.Size(112, 21)
        Me.dtBirth.TabIndex = 2
        '
        'txtFirst
        '
        Me.txtFirst.Location = New System.Drawing.Point(82, 33)
        Me.txtFirst.Name = "txtFirst"
        Me.txtFirst.Size = New System.Drawing.Size(112, 21)
        Me.txtFirst.TabIndex = 0
        '
        'txtClassCode
        '
        Me.txtClassCode.Anchor = CType((((System.Windows.Forms.AnchorStyles.Top Or System.Windows.Forms.AnchorStyles.Bottom) _
                    Or System.Windows.Forms.AnchorStyles.Left) _
                    Or System.Windows.Forms.AnchorStyles.Right), System.Windows.Forms.AnchorStyles)
        Me.txtClassCode.BackColor = System.Drawing.Color.White
        Me.txtClassCode.Font = New System.Drawing.Font("Tahoma", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.txtClassCode.ForeColor = System.Drawing.Color.DarkGreen
        Me.txtClassCode.Location = New System.Drawing.Point(332, 32)
        Me.txtClassCode.Multiline = True
        Me.txtClassCode.Name = "txtClassCode"
        Me.txtClassCode.ReadOnly = True
        Me.txtClassCode.ScrollBars = System.Windows.Forms.ScrollBars.Vertical
        Me.txtClassCode.Size = New System.Drawing.Size(264, 252)
        Me.txtClassCode.TabIndex = 7
        Me.txtClassCode.Text = resources.GetString("txtClassCode.Text")
        '
        'lblCodeCaption
        '
        Me.lblCodeCaption.Font = New System.Drawing.Font("Tahoma", 8.25!, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.lblCodeCaption.Location = New System.Drawing.Point(332, 12)
        Me.lblCodeCaption.Name = "lblCodeCaption"
        Me.lblCodeCaption.Size = New System.Drawing.Size(178, 20)
        Me.lblCodeCaption.TabIndex = 2
        Me.lblCodeCaption.Text = "Kod definicji klasy Person:"
        '
        'cmdClose
        '
        Me.cmdClose.Anchor = CType((System.Windows.Forms.AnchorStyles.Bottom Or System.Windows.Forms.AnchorStyles.Right), System.Windows.Forms.AnchorStyles)
        Me.cmdClose.DialogResult = System.Windows.Forms.DialogResult.Cancel
        Me.cmdClose.Location = New System.Drawing.Point(504, 300)
        Me.cmdClose.Name = "cmdClose"
        Me.cmdClose.Size = New System.Drawing.Size(92, 28)
        Me.cmdClose.TabIndex = 8
        Me.cmdClose.Text = "Koniec"
        '
        'ControlPanelForm
        '
        Me.AutoScaleBaseSize = New System.Drawing.Size(5, 14)
        Me.CancelButton = Me.cmdClose
        Me.ClientSize = New System.Drawing.Size(604, 334)
        Me.Controls.Add(Me.GroupBox1)
        Me.Controls.Add(Me.cmdClose)
        Me.Controls.Add(Me.lblCodeCaption)
        Me.Controls.Add(Me.txtClassCode)
        Me.Font = New System.Drawing.Font("Tahoma", 8.25!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Name = "ControlPanelForm"
        Me.Text = "Tester obiektw"
        Me.GroupBox1.ResumeLayout(False)
        Me.GroupBox1.PerformLayout()
        Me.ResumeLayout(False)
        Me.PerformLayout()

    End Sub

#End Region
    ' Komentarze przetumaczone w poprzednich przykadach z tego rozdziau. 
    ' Store current Person object in a form-level variable.
    Private CurrentPerson As Person

    Private Sub cmdClose_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cmdClose.Click
        Me.Close()
    End Sub


    Private Sub cmdCreate_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cmdCreate.Click
        CurrentPerson = New Person(txtFirst.Text, txtLast.Text, dtBirth.Value)

        RefreshPerson()
        cmdRelease.Enabled = True
        cmdGetIntro.Enabled = True
        cmdUpdate.Enabled = True
    End Sub

    Private Sub RefreshPerson()
        txtFirst.Text = CurrentPerson.FirstName
        txtLast.Text = CurrentPerson.LastName
        dtBirth.Value = CurrentPerson.BirthDate
    End Sub

    Private Sub cmdRelease_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cmdRelease.Click
        CurrentPerson = Nothing
        cmdRelease.Enabled = False
        cmdGetIntro.Enabled = False
        cmdUpdate.Enabled = False
    End Sub

    Private Sub cmdUpdate_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cmdUpdate.Click
        CurrentPerson.FirstName = txtFirst.Text
        CurrentPerson.LastName = txtLast.Text
        If CurrentPerson.BirthDate <> dtBirth.Value Then
            MessageBox.Show("Sorry, you cannot change the birth date after creating a Person!", _
              "Invalid Update", MessageBoxButtons.OK, MessageBoxIcon.Exclamation)
        End If
        RefreshPerson()
    End Sub

    Private Sub cmdGetIntro_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cmdGetIntro.Click
        MessageBox.Show(CurrentPerson.GetIntroduction(), "Introduction")
        txtIntro.Text = CurrentPerson.GetIntroduction()
    End Sub

    Private Sub ControlPanelForm_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load

    End Sub
End Class

Public Class Person

    ' Data for the Person
    Private _FirstName As String
    Private _LastName As String
    Private _BirthDate As Date

    Public Property FirstName() As String
        Get
            Return _FirstName
        End Get

        Set(ByVal Value As String)
            _FirstName = Value
        End Set
    End Property

    Public Property LastName() As String
        Get
            Return _LastName
        End Get

        Set(ByVal Value As String)
            _LastName = Value
        End Set
    End Property

    Public ReadOnly Property BirthDate() As Date
        Get
            Return _BirthDate
        End Get
    End Property

    ' Constructors.
    Public Sub New(ByVal FirstName As String, ByVal LastName As String, _
     ByVal BirthDate As Date)
        _FirstName = FirstName
        _LastName = LastName
        _BirthDate = BirthDate
    End Sub

    Public Sub New(ByVal FirstName As String, ByVal LastName As String)
        _FirstName = FirstName
        _LastName = LastName
        _BirthDate = DateTime.Now
    End Sub

    Public Sub New(ByVal FirstName As String, ByVal LastName As String, _
     ByVal Age As Integer)
        _FirstName = FirstName
        _LastName = LastName
        _BirthDate = DateTime.Now.AddYears(-Age)
    End Sub

    ' Built-in feature to get the Person object to introduce itself.
    Public Function GetIntroduction() As String
        Dim Intro As String
        Intro = "Nazywam si: " & FirstName & " " & LastName & ". "
        Intro &= "Moja data urodzenia: " & BirthDate.ToString
        Return Intro
    End Function

End Class

