Imports System.Net.NetworkInformation

Module InformacjeOSieci

    Sub Main()

        If My.Computer.Network.IsAvailable Then
            Console.WriteLine("Komputer ma interfejs sieciowy.")
        End If

        ' Pobieramy nazw komputera
        Dim HostName As String = System.Net.Dns.GetHostName()
        Console.WriteLine("Nazwa hosta: " & HostName)

        ' Pobieramy adres IP komputera.
        ' Zwrmy uwag, e poniszy kod w rzeczywistoci pobiera
        ' pierwszy adres na licie, poniewa zakada, e komputerowi
        ' przypisano tylko jeden adres IP (co jest norm)
        Console.WriteLine("IP: " & System.Net.Dns.GetHostEntry(HostName).AddressList(0).ToString())

        Dim Properties As IPGlobalProperties = IPGlobalProperties.GetIPGlobalProperties()
        Dim TcpStat As TcpStatistics
        TcpStat = Properties.GetTcpIPv4Statistics()

        Console.WriteLine("Statystyka TCP/IPv4:")
        Console.WriteLine("Minimalny limit czasu transmisji... : " & _
          TcpStat.MinimumTransmissionTimeout)
        Console.WriteLine("Maksymalny limit czasu transmisji.. : " & _
          TcpStat.MaximumTransmissionTimeout)

        Console.WriteLine("Informacje o poczeniach:")
        Console.WriteLine("  Biece  ........................ : " & _
          TcpStat.CurrentConnections)
        Console.WriteLine("  cznie ......................... : " & _
          TcpStat.CumulativeConnections)
        Console.WriteLine("  Zainicjowane .................... : " & _
          TcpStat.ConnectionsInitiated)
        Console.WriteLine("  Przyjte ........................ : " & _
          TcpStat.ConnectionsAccepted)
        Console.WriteLine("  Nieudane prby .................. : " & _
          TcpStat.FailedConnectionAttempts)
        Console.WriteLine("  Zresetowane ..................... : " & _
          TcpStat.ResetConnections)

        Console.WriteLine()
        Console.WriteLine("Informacje o segmentach:")
        Console.WriteLine("  Odebrane  ....................... : " & _
          TcpStat.SegmentsReceived)
        Console.WriteLine("  Wysane ......................... : " & _
          TcpStat.SegmentsSent)
        Console.WriteLine("  Wysane ponownie ................ : " & _
          TcpStat.SegmentsResent)

        Console.ReadLine()

    End Sub

End Module
