Imports System.Xml.XPath
Imports System.Xml

Module Module1

    Sub Main()

        ' Wczytujemy dokument
        Dim Doc As New XPathDocument( _
          My.Computer.FileSystem.CurrentDirectory & _
          "\ProductList.xml")

        ' Tworzymy obiekt XPathNavigator.
        Dim Navigator As XPathNavigator = Doc.CreateNavigator()

        ' Przechodzimy do gwnego elementu <Products>
        Navigator.MoveToFirstChild()

        ' Przechodzimy do pierwszego zawartego w nim elementu <Product>
        Navigator.MoveToFirstChild()

        ' Przetwarzamy w ptli wszystkie elementy <Product>
        Do
            ' Szukamy elementu <ModelName> wewntrz <Product>
            ' i wywietlamy jego warto
            Navigator.MoveToFirstChild()
            Do
                If Navigator.Name = "ModelName" Then
                    Console.WriteLine(Navigator.Value)
                ElseIf Navigator.Name = "UnitCost" Then
                    Dim Price As Double = Navigator.ValueAsDouble * 1.22
                    Console.WriteLine(vbTab & "Cena z podatkiem: " & Math.Round(Price, 2))
                End If
            Loop While Navigator.MoveToNext()

            ' Przechodzimy z powrotem do elementu <Product>
            Navigator.MoveToParent()
        Loop While Navigator.MoveToNext()
        Console.ReadLine()

        ' Uywamy wyraenia XPath w celu uzyskania interesujcych nas wzw
        ' (w tym przypadku wszystkich nazw produktw z kategorii Narzdzia)
        Dim Ns As New XmlNamespaceManager(Navigator.NameTable)
        Ns.AddNamespace("pc", "http://www.ibuyspy.com/ProductCatalog")

        Console.WriteLine("Produkty z kategorii Narzdzia:")
        Dim XPathIterator As XPathNodeIterator
        XPathIterator = Navigator.Select( _
          "/pc:Products/pc:Product/pc:ModelName[../pc:CategoryName='Narzdzia']", Ns)

        Do While (XPathIterator.MoveNext())
            ' XPathIterator.Current to obiekt XPathNavigator wskazujcy
            ' biecy wze
            Console.WriteLine(XPathIterator.Current.Value)
        Loop
        Console.ReadLine()

    End Sub

End Module
