Imports System.Xml.XPath
Imports System.Xml

Module XPathNavigatorTest

    Sub Main()
        ' Wczytujemy dokument
        Dim Doc As New XPathDocument(My.Computer.FileSystem.CurrentDirectory & "\ProductList.xml")

        ' Tworzymy obiekt XPathNavigator do nawigacji po dokumencie
        Dim Navigator As XPathNavigator = Doc.CreateNavigator()

        ' Uywamy obiektu XPathNodeIterator do zmodyfikowania wartoci
        Dim XPathIterator As XPathNodeIterator = Navigator.Select("//UnitCost")

        ' Zwikszamy cen o 10%
        For Each Editor As XPathNavigator In XPathIterator
            Editor.SetValue((1.1 * Editor.ValueAsDouble).ToString())
        Next

        ' Usuwamy wzy nienalece do kategorii Narzdzia
        XPathIterator = Navigator.Select("/Products/Product[CategoryName!='Narzdzia']")
        For Each Editor As XPathNavigator In XPathIterator
            Editor.DeleteSelf()
        Next

        Dim XPathEditor As XPathNavigator = Navigator.CreateNavigator()
        '' Tworzymy nowy produkt
        ' (poniszy kod nie dziaa w becie 2)
        'XPathEditor.MoveToRoot()
        'XPathEditor.MoveToFirstChild()
        'Dim Writer As XmlWriter = XPathEditor.AppendChild
        'Writer.WriteStartElement("Product", "http://www.ibuyspy.com/ProductCatalog")
        'Writer.WriteElementString("ProductID", "999")
        'Writer.WriteElementString("ModelName", "Rubber Pants")
        'Writer.WriteElementString("ModelNumber", "NOZ999")
        'Writer.WriteElementString("UnitCost", "12.99")
        'Writer.WriteElementString("CategoryName", "Clothing")
        'Writer.WriteEndElement()
        'Writer.Close()

        'Pokazujemy zmiany
        XPathEditor.MoveToRoot()
        Console.WriteLine(XPathEditor.OuterXml)
        'Doc.Save(My.Computer.FileSystem.CurrentDirectory & "\ProductList_new.xml")

        Console.ReadLine()

    End Sub

End Module
