Imports System.IO

Module Module1

    Sub Main()
        Console.WriteLine("Dyski w tym komputerze: ")
        For Each Drive As DriveInfo In My.Computer.FileSystem.Drives
            ' Wywietlamy informacje o dyskach
            Console.WriteLine(Drive.Name)

            Console.WriteLine(vbTab & "Typ: " & Drive.DriveType.ToString())

            If (Drive.DriveType And DriveType.Fixed) = DriveType.Fixed Then
                Console.WriteLine(vbTab & "Format: " & Drive.DriveFormat.ToString())
                Console.WriteLine(vbTab & "Etykieta: " & Drive.VolumeLabel)
                Console.WriteLine(vbTab & "Cakowity rozmiar: " & Drive.TotalSize)
                Console.WriteLine(vbTab & "Wolne miejsce: " & Drive.TotalFreeSpace)
            End If
            Console.WriteLine()
        Next

        Console.WriteLine()
        Dim Info As FileInfo

        ' Pobieramy informacje o konkretnym pliku
        Info = My.Computer.FileSystem.GetFileInfo("c:\Windows\explorer.exe")

        ' Wywietlamy czasy dostpu i aktualizacji
        Console.WriteLine("Utworzono: " & Info.CreationTime)
        Console.WriteLine("Czas ostatniej modyfikacji: " & Info.LastWriteTime)
        Console.WriteLine("Czas ostatniego dostpu: " & Info.LastAccessTime)

        ' Sprawdzamy, czy plik jest przeznaczony tylko do odczytu.
        ' Podczas sprawdzania waciwoci pliku trzeba uywa arytmetyki
        ' bitowej, poniewa kolekcja FileAttributes zwykle zawiera
        ' kilka rnych atrybutw.
        Dim ReadOnlyFile As Boolean
        ReadOnlyFile = Info.Attributes And FileAttributes.ReadOnly
        Console.WriteLine("Tylko do odczytu: " & ReadOnlyFile)

        ' Wywietlamy rozmiar pliku
        Console.WriteLine("Rozmiar (w bajtach): " & Info.Length)

        Console.WriteLine()
        Console.WriteLine("Nacinij klawisz Enter, aby przeprowadzi wyszukiwanie.")
        Console.ReadLine()
        ' Pobieramy wszystkie pliki exe w katalogu Windows
        For Each File As String In My.Computer.FileSystem.GetFiles( _
          "c:\windows", FileIO.SearchOption.SearchAllSubDirectories, "*.exe")
            Info = My.Computer.FileSystem.GetFileInfo(File)
            Console.WriteLine(Info.Name & " w katalogu " & Info.Directory.Name)
        Next

        Console.WriteLine("Gotowe.")
        Console.ReadLine()


    End Sub

End Module
