
Imports System.Data.SqlClient
Imports System.Data
Imports System.IO

Public Class Form1

    Private Sub Form1_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        Dim ds As DataSet = GetDataSet()
        DataGridView1.DataSource = ds
        DataGridView1.DataMember = "pub_info"

        DataGridView1.ShowCellToolTips = False

        ' Ukrywamy dane binarne
        DataGridView1.Columns("logo").Visible = False

        ' Dodajemy kolumn obrazu
        Dim ImageCol As New DataGridViewImageColumn()
        ImageCol.Name = "Image"
        ImageCol.Width = 200
        DataGridView1.Columns.Add(ImageCol)

        For Each Row As DataGridViewRow In DataGridView1.Rows
            ' Najpierw musimy przeksztaci dane binarne w strumie pamiciowy
            ' Nastpnie moemy uy strumienia pamiciowego do utworzenia obiektu Image
            Try
                Dim ImageBytes() As Byte = Row.Cells("logo").Value

                Dim ms As New MemoryStream(ImageBytes)
                Dim img As Image = Image.FromStream(ms)

                ' Wiemy kolumn obrazu
                Dim ImageCell As DataGridViewImageCell = CType(Row.Cells("Image"), _
                  DataGridViewImageCell)
                ImageCell.Value = img

                ' Teraz moemy usun pierwotne informacje, aby zaoszczdzi miejsce
                Row.Cells("logo").Value = New Byte() {}

                Row.Height = 100
            Catch
                ' Ignorujemy bdy spowodowane bdnymi obrazami
            End Try

        Next


    End Sub

    Private Sub SaveDataSet()
        Dim connectionString As String = _
        "Data Source=localhost;Initial Catalog=pubs;Integrated Security=SSPI"
        Dim sqlSelect As String = _
        "SELECT * FROM pub_info"
        Dim ds As New DataSet()
        Dim adapter As New SqlDataAdapter(sqlSelect, connectionString)
        adapter.Fill(ds, "pub_info")
        ds.WriteXmlSchema(Application.StartupPath & "\ds.xsd")
        ds.WriteXml(Application.StartupPath & "\ds.xml")
    End Sub

    Private Function GetDataSet() As DataSet
        Dim ds As New DataSet()
        ds.ReadXmlSchema(Application.StartupPath & "\ds.xsd")
        ds.ReadXml(Application.StartupPath & "\ds.xml")
        Return ds
    End Function

    Private Sub DataGridView1_CellContentClick(ByVal sender As System.Object, ByVal e As System.Windows.Forms.DataGridViewCellEventArgs) Handles DataGridView1.CellContentClick

    End Sub
End Class
