Imports System.Data.SqlClient
Imports System.Data

Public Class Siatka

    Private Sub Grid_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        Dim ds As DataSet
        ds = GetDataSet()
        DataGridView1.DataSource = ds
        DataGridView1.DataMember = "Customers"
        DataGridView1.AutoResizeColumns(DataGridViewAutoSizeColumnsMode.DisplayedCells)
        DataGridView1.AutoResizeRows(DataGridViewAutoSizeRowsMode.AllCells)
        DataGridView1.Columns("CustomerID").DisplayIndex = 0
        DataGridView1.Columns("CustomerID").Frozen = True
        DataGridView1.Columns("CustomerID").HeaderText = "ID"
        DataGridView1.Columns("CustomerID").ReadOnly = True
        DataGridView1.Columns("CustomerID").Resizable = DataGridViewTriState.True
        DataGridView1.Columns("CustomerID").MinimumWidth = 50

        DataGridView1.SelectionMode = DataGridViewSelectionMode.FullRowSelect

        Dim Style As DataGridViewCellStyle = DataGridView1.Columns("CustomerID").DefaultCellStyle
        Style.Font = New Font(DataGridView1.Font, FontStyle.Bold)
        Style.Alignment = DataGridViewContentAlignment.MiddleRight
        Style.BackColor = Color.LightYellow
        Style.ForeColor = Color.DarkRed


        ' Tworzymy kolumn z przyciskami
        Dim Details As New DataGridViewButtonColumn()
        Details.Name = "Details"

        ' Wyczamy wizanie danych i pokazujemy statyczny tekst
        ' (zamiast tego moglibymy uy wartoci z tabeli,
        ' ustawiajc waciwo DataPropertyName)
        Details.UseColumnTextForButtonValue = True
        Details.Text = "Szczegy..."

        ' Usuwamy nagwek
        Details.HeaderText = ""

        ' Dodajemy kolumn
        DataGridView1.Columns.Insert(DataGridView1.Columns.Count, Details)

    End Sub

    Private Sub SaveDataSet()
        Dim connectionString As String = _
        "Data Source=localhost;Initial Catalog=Northwind;Integrated Security=SSPI"
        Dim sqlSelect As String = _
        "SELECT CustomerID, CompanyName, ContactName, ContactTitle, Address, City, Country FROM Customers"
        Dim ds As New DataSet()
        Dim adapter As New SqlDataAdapter(sqlSelect, connectionString)
        adapter.Fill(ds, "Customers")
        ds.WriteXmlSchema(Application.StartupPath & "\ds.xsd")
        ds.WriteXml(Application.StartupPath & "\ds.xml")
    End Sub

    Private Function GetDataSet() As DataSet
        Dim ds As New DataSet()
        ds.ReadXmlSchema(Application.StartupPath & "\ds.xsd")
        ds.ReadXml(Application.StartupPath & "\ds.xml")
        Return ds
    End Function

    Private Sub cmdSelection_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cmdSelection.Click
        For Each SelectedRow As DataGridViewRow In DataGridView1.SelectedRows
            MessageBox.Show(SelectedRow.Cells("CustomerID").Value)
        Next
    End Sub

    Private Sub DataGridView1_CellFormatting(ByVal sender As System.Object, ByVal e As System.Windows.Forms.DataGridViewCellFormattingEventArgs) Handles DataGridView1.CellFormatting

        ' Sprawdzamy, czy jest to waciwa kolumna
        If DataGridView1.Columns(e.ColumnIndex).Name = "CustomerID" Then
            ' Sprawdzamy, czy jest to waciwa warto
            If e.Value = "ALFKI" Then
                e.CellStyle.ForeColor = Color.Red
                e.CellStyle.BackColor = Color.Yellow
            End If
        End If

    End Sub

    Private Sub DataGridView1_CellClick(ByVal sender As System.Object, ByVal e As System.Windows.Forms.DataGridViewCellEventArgs) Handles DataGridView1.CellClick

        If DataGridView1.Columns(e.ColumnIndex).Name = "Details" Then
            MessageBox.Show("Wybrae " & _
            DataGridView1.Rows(e.RowIndex).Cells("CustomerID").Value)
        End If

    End Sub

    End Class
