Public Class Form1

    Private Sub Form1_Load(ByVal sender As System.Object, _
      ByVal e As System.EventArgs) Handles MyBase.Load
        ' Zapobiegamy przeciganiu i upuszczaniu czy do przegldarki
        Browser.AllowWebBrowserDrop = False

        ' Przechodzimy do lokalnej strony dokumentacji
        Browser.Url = New Uri("file:///" & _
          Application.StartupPath & "\Doc.html")
    End Sub

    Private Sub Browser_Navigating(ByVal sender As Object, _
      ByVal e As WebBrowserNavigatingEventArgs) Handles Browser.Navigating
        If Not e.Url.IsFile Then
            ' Nie przechodzimy do zewntrznej strony WWW
            ' Zamiast tego uywamy metody Navigate(), aby otworzy
            ' samodzielne okno IE
            e.Cancel = True
            Browser.Navigate(e.Url, True)
        End If
    End Sub

    Private Sub Browser_Navigated(ByVal sender As Object, _
      ByVal e As WebBrowserNavigatedEventArgs) Handles Browser.Navigated
        ' Pokazujemy pasek postpu
        Progress.Visible = True
    End Sub

    Private Sub Browser_ProgressChanged(ByVal sender As Object, _
      ByVal e As WebBrowserProgressChangedEventArgs) Handles Browser.ProgressChanged

        ' Aktualizujemy pasek postpu
        Progress.Maximum = e.MaximumProgress
        Progress.Value = e.CurrentProgress
    End Sub

    Private Sub Browser_DocumentCompleted(ByVal sender As Object, _
      ByVal e As WebBrowserDocumentCompletedEventArgs) Handles Browser.DocumentCompleted

        ' Ukrywamy pasek postpu
        Progress.Visible = False
    End Sub

    Private Sub Browser_StatusTextChanged(ByVal sender As Object, _
      ByVal e As EventArgs) Handles Browser.StatusTextChanged
        ' Wywietlamy tekst, ktry IE pokazaby w pasku stanu
        Status.Text = Browser.StatusText
    End Sub


End Class
