Imports System
Imports System.IO

Module Module1

    Sub Main()
        ' Tworzymy instancj GenericList i wybieramy typ (w tym przypadku String)
        Dim List As New GenericList(Of String)

        ' Dodajemy dwa acuchy
        List.Add("niebieski")
        List.Add("zielony")

        ' Nastpna instrukcja nie zadziaa, poniewa dodaje do kolekcji bdny typ.
        ' Nie mona automatycznie przeksztaci identyfikatora GUID w acuch.
        ' Prawd mwic, wiersz ten nie zostanie nigdy wykonany, poniewa kompilator
        ' wykryje problem i odmwi zbudowania aplikacji.
        'List.Add(Guid.NewGuid())

        ' Ta niestandardowa kolekcja nadal obsuguje wyliczanie:
        For Each Item As String In List
            Console.WriteLine(Item)
        Next
        Console.ReadLine()

    End Sub

End Module

Public Class GenericList(Of ItemType)
    Inherits CollectionBase

    Public Function Add(ByVal value As ItemType) As Integer
        Return List.Add(value)
    End Function

    Public Sub Remove(ByVal value As ItemType)
        List.Remove(value)
    End Sub

    Public ReadOnly Property Item(ByVal index As Integer) As ItemType
        Get
            ' Odpowiedni element jest pobierany z obiektu List i jawnie
            ' rzutowany na odpowiedni typ, a nastpnie zwracany
            Return CType(List.Item(index), ItemType)
        End Get
    End Property
End Class
