Imports System.Data.SqlClient

Module Module1
    Private ConnectSource As String = "Data Source=localhost;Initial Catalog=Northwind;Integrated Security=SSPI"
    Private ConnectTarget As String = "Data Source=localhost;Initial Catalog=NorthwindCopy;Integrated Security=SSPI"

    Public Sub Main()
        ' Tworzymy poczenie rdowe i docelowe
        Dim conSource As New SqlConnection(ConnectSource)
        Dim conTarget As New SqlConnection(ConnectTarget)

        ' Tworzymy polecenie do zliczania wierszy w tabeli
        Dim cmdCount As New SqlCommand("SELECT COUNT(*) FROM CustomersShort", conTarget)

        ' Inicjalizujemy klas SqlBulkCopy informacjami o odwzorowaniach
        Dim BCP As New SqlClient.SqlBulkCopy(conTarget)
        BCP.DestinationTableName = "CustomersShort"
        BCP.ColumnMappings.Add("CustomerID", "ID")
        BCP.ColumnMappings.Add("CompanyName", "Company")
        BCP.ColumnMappings.Add("ContactName", "Contact")

        ' Zliczamy wiersze w tabeli CustomersShort
        conTarget.Open()
        Dim Rows As Integer = CInt(cmdCount.ExecuteScalar())
        Console.WriteLine("Tabela CustomersShort zawiera " & Rows & " wierszy.")
        Console.WriteLine("Rozpoczto kopiowanie hurtowe...")

        ' Pobieramy dane przeznaczone do przeniesienia
        conSource.Open()
        Dim cmd As New SqlCommand( _
          "SELECT CustomerID,CompanyName,ContactName FROM Customers", conSource)
        Dim reader As SqlDataReader = cmd.ExecuteReader()

        ' Zapisujemy dane w docelowej tabeli
        BCP.WriteToServer(reader)

        ' Porzdkujemy
        BCP.Close()
        reader.Close()
        conSource.Close()

        ' Ponownie zliczamy wiersze w tabeli CustomersShort
        conSource.Open()
        Rows = CInt(cmdCount.ExecuteScalar())
        Console.WriteLine("Zakoczono kopiowanie hurtowe.")
        Console.WriteLine("Tabela CustomersShort zawiera " & Rows & " wierszy.")

        conTarget.Close()
        Console.ReadLine()
    End Sub



End Module
