Imports System.IO
Imports System.IO.Compression

Module Module1

    Sub Main()
        ' Odczytujemy pierwotny plik
        Dim SourceFile As String = My.Computer.FileSystem.CurrentDirectory & "\test.txt"
        Dim fsRead As New FileStream(SourceFile, FileMode.Open)
        Dim FileBytes(CInt(fsRead.Length) - 1) As Byte
        fsRead.Read(FileBytes, 0, FileBytes.Length)
        fsRead.Close()

        ' Zapisywanie danych w nowym, skompresowanym pliku
        Dim TargetFile As String = My.Computer.FileSystem.CurrentDirectory & "\test.bin"
        Dim fsWrite As New FileStream(TargetFile, FileMode.Create)
        Dim CompressStream As New GZipStream(fsWrite, CompressionMode.Compress)
        CompressStream.Write(FileBytes, 0, FileBytes.Length)
        CompressStream.Flush()
        CompressStream.Close()
        fsWrite.Close()

        Console.WriteLine("Plik skompresowano z " & _
          New FileInfo(SourceFile).Length & " bajtw do " & _
          New FileInfo(TargetFile).Length & " bajtw.")

        Console.WriteLine("Nacinij Enter, aby zdekompresowa plik.")
        Console.ReadLine()

        fsRead = New FileStream(TargetFile, FileMode.Open)
        Dim DecompressStream As New GZipStream(fsRead, CompressionMode.Decompress)
        Dim Reader As New StreamReader(CType(DecompressStream, Stream))
        Console.WriteLine(Reader.ReadToEnd())
        Reader.Close()
        fsRead.Close()

        Console.ReadLine()

    End Sub

End Module
