Imports System.Data.SqlClient

Module Module1

    Private ConnectString As String = _
      "Data Source=localhost;Initial Catalog=Northwind;Integrated Security=SSPI"
    Private con As New SqlConnection(ConnectString)

    Sub Main()
        ' Wczamy gromadzenie danych statystycznych
        con.StatisticsEnabled = True

        Dim Query As String = "SELECT * FROM Orders"
        Dim cmd As New SqlCommand(Query, con)
        Dim Adapter As New SqlDataAdapter(cmd)
        Dim CommandBuilder As New SqlCommandBuilder(Adapter)

        Dim ds As New DataSet
        con.Open()
        Adapter.Fill(ds, "Orders")
        con.Close()

        ' Wykonujemy aktualizacj bez czenia polece
        ChangeRows(ds)
        con.ResetStatistics()
        Adapter.Update(ds, "Orders")
        Console.WriteLine("Statystyka trybu zwykego....")
        DisplayStatistics()

        ' Wykonujemy aktualizacj wsadow (15 wierszy w grupie)
        ChangeRows(ds)
        con.ResetStatistics()
        Adapter.UpdateBatchSize = 15
        con.Open()
        Adapter.Update(ds, "Orders")
        con.Close()
        Console.WriteLine("Statystyka trybu wsadowego....")
        DisplayStatistics()

        Console.ReadLine()

    End Sub

    Public Sub ChangeRows(ByVal ds As DataSet)
        For Each Row As DataRow In ds.Tables("Orders").Rows
            Row("ShippedDate") = DateTime.Now
        Next
    End Sub

    Public Sub DisplayStatistics()
        ' Pobieramy tabel przestawn z danymi statystycznymi
        Dim Stats As Hashtable = con.RetrieveStatistics()

        ' Wywietlamy wszystkie dane
        For Each Key As String In Stats.Keys
            Console.WriteLine(Key & " = " & Stats(Key))
        Next
        Console.WriteLine()
    End Sub

End Module
