Imports System.IO

Public Class Form1

    Private Sub Form1_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        ' Set the first node.
        Dim RootNode As New TreeNode("c:\")
        treeFiles.Nodes.Add(RootNode)

        ' Fill the first level and expand it.
        Fill(RootNode)
        treeFiles.Nodes(0).Expand()
    End Sub

    Private Sub Fill(ByVal dirNode As TreeNode)

        Dim Dir As New DirectoryInfo(dirNode.FullPath)
        Dim DirItem As DirectoryInfo

        Try
            For Each DirItem In Dir.GetDirectories
                ' Add node for the directory.
                Dim NewNode As New TreeNode(DirItem.Name)
                dirNode.Nodes.Add(NewNode)
                NewNode.Nodes.Add("*")
            Next
        Catch Err As UnauthorizedAccessException
            ' Error thrown if you don't have security permissions
            ' to access directory - ignore it.
        End Try

    End Sub

    Private Sub treeFiles_BeforeExpand(ByVal sender As System.Object, ByVal e As System.Windows.Forms.TreeViewCancelEventArgs) Handles treeFiles.BeforeExpand
        ' Check for the dummy node.
        If e.Node.Nodes(0).Text = "*" Then
            ' Disable redraw.
            treeFiles.BeginUpdate()

            e.Node.Nodes.Clear()
            Fill(e.Node)

            ' Enable redraw.
            treeFiles.EndUpdate()
        End If

    End Sub

    Private Sub treeFiles_AfterSelect(ByVal sender As System.Object, ByVal e As System.Windows.Forms.TreeViewEventArgs) Handles treeFiles.AfterSelect
        lstFiles.Items.Clear()
        For Each File As String In Directory.GetFiles(e.Node.FullPath)
            lstFiles.Items.Add(Path.GetFileName(File))
        Next
    End Sub

    Private Sub cmdClose_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cmdClose.Click
        Me.Close()
    End Sub

    Private Sub lstFiles_SelectedIndexChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles lstFiles.SelectedIndexChanged

    End Sub

End Class
