Imports System.IO
Imports System.Security.Cryptography

''' <summary>
''' Ta klasa zawiera metody do porwnywania plikw.
''' </summary>
''' <remarks>
'''		<para>Klasa nie utrzymuje informacji o stanie. Nie jest jednak
''' bezpieczna, jeli ktry z plikw zosta ju otwarty przez inny
''' proces.</para>
'''		<para>Klasa zawiera nastpujce metody:</para>
'''		<list type="bullet">
'''			<item><see cref="FileComparer.TestIfTwoFilesMatch"/>
''' TestifTwoFilesMatch() porwnuje dwa pliki na podstawie ich skrtw.</item>
'''		</list>
''' </remarks>
Public Class FileComparer
    ''' <summary>
    ''' Ta funkcja spradza, czy dwa pliki
    ''' maj dokadnie tak sam tre.
    ''' </summary>
    ''' <param name="fileA">Zawiera pen ciek do pierwszego pliku.</param>
    ''' <param name="fileB">Zawiera pen ciek do drugiego pliku.</param>
    ''' <returns>True, jeli pliki pasuj, false jeli nie.</returns>
    ''' <remarks>
    ''' Implementacja metody uywa klas kryptograficznych do obliczenia skrtu.
    ''' Moe nie jest to najwydajniejsza metoda, ale wykrywa najdrobniejsze
    ''' rnice i praktycznie nie sposb jej oszuka.
    ''' </remarks>
    Public Function TestIfTwoFilesMatch(ByVal fileA As String, _
          ByVal fileB As String) As Boolean

        ' Tworzenie obiektu obliczajcego skrt
        Dim Hash As HashAlgorithm = HashAlgorithm.Create()

        ' Obliczanie skrtu pierwszego pliku
        Dim fsA As New FileStream(fileA, FileMode.Open)
        Dim HashA() As Byte = Hash.ComputeHash(fsA)
        fsA.Close()

        ' Obliczanie skrtu drugiego pliku
        Dim fsB As New FileStream(fileB, FileMode.Open)
        Dim HashB() As Byte = Hash.ComputeHash(fsB)
        fsB.Close()

        ' Porwnywanie skrtw
        Return (Convert.ToString(HashA) = Convert.ToString(HashB))

    End Function

End Class
