Option Strict On

    Imports Microsoft.VisualBasic
    Imports System
    Imports System.Reflection
    Imports System.Text

    ' ----- Atrybut <DeveloperNote> umieszczono w
    '       przestrzeni nazw Extensions.CustomAttributes.
    Imports Extensions.CustomAttributes

    Module modComments

    Public Sub Main(  )
       ' ----- Generuje raport na bazie atrybutu <DeveloperNote> uytego w danym podzespole.
       Dim fileToExamine As String
       Dim outputText As String
       Dim assemblyView As System.Reflection.Assembly
       Dim attributeSet(  ) As Attribute
       Dim moduleScan As System.Reflection.Module
       Dim moduleSet(  ) As System.Reflection.Module

       ' ----- Podzesp bdcy przedmiotem analizy przekazano za porednictwem parametru wiersza polecenia.
       fileToExamine = Command(  )
       If (fileToExamine = "") Then
          Console.WriteLine("Prawidowa skadnia:" & vbCrLf & _
             "   DevNotes <nazwaPliku>")
          Exit Sub
       End If

       ' ----- aduje podzesp .NET za porednictwem klasy refleksji.
       assemblyView = Reflection.Assembly.LoadFrom(fileToExamine)

       ' ----- Wywietla informacje o atrybutach zdefiniowanych na poziomie podzespou.
       attributeSet = Attribute.GetCustomAttributes(assemblyView)
       If (attributeSet.Length > 0) Then
          outputText = PrepareDeveloperNotes(attributeSet)
          If (outputText <> "") Then
             Console.WriteLine(assemblyView.GetName.Name & _
                " Uwagi autora podzespou:")
             Console.WriteLine(outputText)
          End If
       End If

       ' ----- Wywietla informacje o atrybutach zdefiniowanych na poziomie moduu.
       moduleSet = assemblyView.GetModules(  )
       For Each moduleScan In moduleSet
          attributeSet = Attribute.GetCustomAttributes(moduleScan)
          If (attributeSet.Length > 0) Then
             outputText = PrepareDeveloperNotes(attributeSet)
             If (outputText <> "") Then
                Console.WriteLine(moduleScan.Name & _
                   " Uwagi autora moduu:")
                Console.WriteLine(outputText)
             End If
          End If
       Next moduleScan
       ' ----- Wywietla informacje o atrybutach zdefiniowanych na poziomie typu.
       EnumerateTypes(assemblyView)
    End Sub

    Public Function PrepareDeveloperNotes(attributeSet(  ) As Object) _
          As String
       ' ----- Formatuje informacje o kadym z atrybutw.
       Dim msg As New StringBuilder
       Dim attributeScan As Attribute
       Dim noteEntry As DeveloperNoteAttribute

       On Error Resume Next

       ' ----- Buduje komunikat obejmujcy waciwoci atrybutu.
       For Each attributeScan In attributeSet
          If (TypeOf (attributeScan) Is DeveloperNoteAttribute) Then
             noteEntry = CType(attributeScan, DeveloperNoteAttribute)
             msg.Append("  Programista: " & noteEntry.Name & vbCrLf)
             msg.Append("  Komentarz: " & noteEntry.Comment & vbCrLf)
             msg.Append("  Data: " & noteEntry.DateRecorded & vbCrLf)
             msg.Append("  Bd: " & noteEntry.Bug & vbCrLf)
          End If
       Next attributeScan

       ' ----- Zwraca wynik w formie standardowego acucha znakowego.
       Return msg.ToString
    End Function

    Private Sub EnumerateTypes(assemblyView As Reflection.Assembly)
       ' ----- Przetwarza poszczeglne typy w ramach danego podzespou.
       Dim typeScan As Type
       Dim typeSet(  ) As Type
       Dim typeCategory As String
       Dim attributeSet(  ) As Object
       Dim attributeMsg As String
       Dim methodMsg As String

       ' ----- Odczytuje typy dla danego podzespou.
       typeSet = assemblyView.GetTypes(  )

       ' ----- Przypisuje zrozumiae (przyjazne) nazwy poszczeglnym kategoriom typw.
       For Each typeScan In typeSet
          If typeScan.IsClass Then
             typeCategory = "Klasa"
          ElseIf typeScan.IsValueType Then
             typeCategory = "Struktura"
          ElseIf typeScan.IsInterface Then
             typeCategory = "Interfejs"
          ElseIf typeScan.IsEnum Then
             typeCategory = "Typ wyliczeniowy"
          Else
             typeCategory = "Typ .NET"
          End If

          ' ----- Odczytuje wszelkie atrybuty na poziomie typu.
          attributeSet = typeScan.GetCustomAttributes(False)
          If (attributeSet.Length > 0) Then
             attributeMsg = PrepareDeveloperNotes(attributeSet)
          Else
             attributeMsg = ""
          End If

          ' ----- Odczytuje szczegowe informacje o skadowych danego typu.
          methodMsg = EnumerateTypeMembers(typeScan)

          ' ----- Wywietla wszystkie dostpne informacje o kolekcji.
          If (methodMsg <> "") Or (attributeMsg <> "") Then
             Console.WriteLine(typeCategory & " " & typeScan.Name & ":")
             If (attributeMsg <> "") Then _
                Console.WriteLine(attributeMsg)
             If (methodMsg <> "") Then _
                Console.WriteLine(methodMsg)
          End If
       Next typeScan
    End Sub

    Private Function EnumerateTypeMembers(typeEntry As Type) As String
       Dim memberInfo As String
       Dim fullInfo As String = ""
       Dim noteDetails As String
       Dim attributeSet(  ) As Object
       Dim memberScan As MemberInfo
       Dim memberSet(  ) As MemberInfo

       ' ----- Uzyskuje skadowe danego typu.
       memberSet = typeEntry.GetMembers
       For Each memberScan In memberSet
          ' ----- Okrela, czy zdefiniowano jakiekolwiek atrybuty.
          attributeSet = memberScan.GetCustomAttributes(False)
          If (attributeSet.Length > 0) Then
             ' ----- Okrela typ skadowej.
             Select Case memberScan.MemberType
                Case MemberTypes.All
                   memberInfo = "Dowolna "
                Case MemberTypes.Constructor
                   memberInfo = "Konstruktor "
                Case MemberTypes.Custom
                   memberInfo = "Metoda niestandardowa "
                Case MemberTypes.Event
                   memberInfo = "Zdarzenie "
                Case MemberTypes.Field
                   memberInfo = "Pole "
                Case MemberTypes.Method
                   memberInfo = "Metoda "
                Case MemberTypes.NestedType
                   memberInfo = "Typ zagniedony "
                Case MemberTypes.Property
                   memberInfo = "Waciwo "
                Case MemberTypes.TypeInfo
                   memberInfo = "Informacja o typie "
                Case Else
                   memberInfo = "Skadowa"
             End Select

             ' ----- Dodaje nazw skadowej.
             If (memberScan.Name = ".ctor") Then
                ' ----- Konstruktor.
                memberInfo = memberInfo & "New"
             Else
                memberInfo = memberInfo & memberScan.Name
             End If

             ' ----- Odczytuje szczegow zawarto notatki programisty.
             noteDetails = PrepareDeveloperNotes(attributeSet)
             If (noteDetails <> "") Then _
                fullInfo &= memberInfo & vbCrLf & noteDetails & vbCrLf
          End If
       Next memberScan

       ' ----- Zwraca w peni sformatowan, gotow do uycia notatk.
       Return fullInfo
    End Function

    End Module
