Public Class Person
   ' ----- Pola skadowe -----
   Private fullName As String
   Private currentAge As Short
   Public Const MAX_AGE As Short = 120

   ' ----- Zdarzenie skadowe -----
   Public Event Testing()

   ' ----- Metoda skadowa konstruktora -----
   Public Sub New()
      ' ----- Konstruktor domylny.
      fullName = "<unnamed>"
   End Sub

   Public Sub New(ByVal newName As String)
      ' ----- Prosty konstruktor ustawiajcy warto pocztkow pola fullName.
      fullName = newName
   End Sub

   ' ----- Metoda skadowa -----
   Public Sub Test()
      ' ----- Sprawdza zdarzenie definiowane przez t klas.
      RaiseEvent Testing()
   End Sub

   Public Overrides Function ToString() As String
      ' ----- Zwraca odpowiednio sformatowany acuch reprezentujcy zawarto tego egzemplarza.
      '       UWAGA: Sowo kluczowe Overrides omwimy w dalszej czci
      '              tego rozdziau.
      Return fullName & ", Wiek " & currentAge
   End Function

   ' ----- Waciwoci skadowe -----
   Public Property Age() As Short
      ' ----- Waciwo Age odpowiada za prost weryfikacj poprawnoci danych.
      Get
         Return currentAge
      End Get
      Set(ByVal value As Short)
         If (value < 0) Or (value > MAX_AGE) Then
            Throw New System.ArgumentException( _
               "Warto skadowej Age musi nalee do przedziau od 0 do " & MAX_AGE & ".", "Age")
         Else
            currentAge = value
         End If
      End Set
   End Property

   Public Property Name() As String
      ' ----- Waciwo Name dodaje specjaln logik; skadowa Name
      '       rwnie dobrze mogaby mie posta pola publicznego.
      Get
         Return fullName
      End Get
      Set(ByVal value As String)
         fullName = value
      End Set
   End Property
End Class
