Option Strict On
Imports System

Namespace Extensions.CustomAttributes

<AttributeUsage(AttributeTargets.All, _
   Inherited:=True, _
   AllowMultiple:=True)> _
Public Class DeveloperNoteAttribute
   Inherits System.Attribute

   Protected developerName As String
   Protected codeComment As String
   Protected codeRecordDate As Date
   Protected dueToBug As Boolean

   Public Sub New(Name As String, Comment As String, _
         DateRecorded As String)
      ' ----- Store the commentary for this program element.
      MyBase.New(  )
      developerName = Name
      codeComment = Comment
      codeRecordDate = CDate(DateRecorded)
   End Sub

   Public Property Name(  ) As String
      Get
         Return developerName
      End Get
      Set(ByVal value As String)
         developerName = value
      End Set
   End Property

   Public Property Comment(  ) As String
      Get
         Return codeComment
      End Get
      Set(ByVal value As String)
         codeComment = value
      End Set
   End Property

   Public Property DateRecorded(  ) As Date
      Get
         Return codeRecordDate
      End Get
      Set(ByVal value As Date)
         codeRecordDate = value
      End Set
   End Property

   Public Property Bug(  ) As Boolean
      Get
         Return dueToBug
      End Get
      Set(ByVal value As Boolean)
         dueToBug = value
      End Set
   End Property
End Class

End Namespace
