﻿'Importowanie przestrzeni nazw Data i SqlClient.
Imports System.Data
Imports System.Data.SqlClient

Public Class Form1
    'Deklaracja obiektów.
    Dim objConnection As New SqlConnection _
        ("server=localhost\WROX;database=pubs;user id=sa;password=wrox;")
    Dim objDataAdapter As New SqlDataAdapter( _
        "SELECT authors.au_id, au_lname, au_fname, " & _
        "titles.title_id, title, price " & _
        "FROM authors " & _
        "JOIN titleauthor ON authors.au_id = titleauthor.au_id " & _
        "JOIN titles ON titleauthor.title_id = titles.title_id " & _
        "ORDER BY au_lname, au_fname", objConnection)
    Dim objDataSet As DataSet
    Dim objDataView As DataView
    Dim objCurrencyManager As CurrencyManager

    Private Sub FillDataSetAndView()
        'Inicjowanie nowego egzemplarza obiektu DataSet.
        objDataSet = New DataSet()

        'Zapełnianie obiektu DataSet danymi.
        objDataAdapter.Fill(objDataSet, "authors")

        'Przypisanie obiektu DataSet do obiektu DataView.
        objDataView = New DataView(objDataSet.Tables("authors"))

        'Ustawienie obiektu CurrencyManager na obiekt DataView.
        objCurrencyManager = CType(Me.BindingContext(objDataView), CurrencyManager)
    End Sub

    Private Sub BindFields()
        'Usuwanie wszystkich istniejących wiązań.
        txtLastName.DataBindings.Clear()
        txtFirstName.DataBindings.Clear()
        txtBookTitle.DataBindings.Clear()
        txtPrice.DataBindings.Clear()

        'Dodawanie nowych wiązań z obiektem DataView.
        txtLastName.DataBindings.Add("Text", objDataView, "au_lname")
        txtFirstName.DataBindings.Add("Text", objDataView, "au_fname")
        txtBookTitle.DataBindings.Add("Text", objDataView, "title")
        txtPrice.DataBindings.Add("Text", objDataView, "price")

        'Wyświetlanie stanu gotowości.
        ToolStripStatusLabel1.Text = "Gotowe"
    End Sub

    Private Sub ShowPosition()
        'Formatowanie liczby w polu txtPrice, aby program wyświetlał grosze.
        Try
            txtPrice.Text = Format(CType(txtPrice.Text, Decimal), "##0.00")
        Catch e As System.Exception
            txtPrice.Text = "0"
            txtPrice.Text = Format(CType(txtPrice.Text, Decimal), "##0.00")
        End Try
        'Wyświetlanie aktualnej pozycji i liczby rekordów.
        txtRecordPosition.Text = objCurrencyManager.Position + 1 & _
           " z " & objCurrencyManager.Count()
    End Sub

    Private Sub Form1_Load(ByVal sender As System.Object, _
                                 ByVal e As System.EventArgs) Handles MyBase.Load
        'Dodawanie elementów do kontrolki ComboBox.
        cboField.Items.Add("Nazwisko")
        cboField.Items.Add("Imię")
        cboField.Items.Add("Tytuł książki")
        cboField.Items.Add("Cena")

        'Wybranie pierwszego elementu.
        cboField.SelectedIndex = 0

        'Zapełnianie obiektu DataSet i wiązanie pól.
        FillDataSetAndView()
        BindFields()

        'Wyświetlanie aktualnego rekordu.
        ShowPosition()
    End Sub

    Private Sub btnMoveFirst_Click(ByVal sender As Object, _
                ByVal e As System.EventArgs) Handles btnMoveFirst.Click
        'Ustawienie pozycji na pierwszy rekord.
        objCurrencyManager.Position = 0

        'Wyświetlenie aktualnego rekordu.
        ShowPosition()
    End Sub

    Private Sub btnMovePrevious_Click(ByVal sender As Object, _
                ByVal e As System.EventArgs) Handles btnMovePrevious.Click
        'Przejście do poprzedniego rekordu.
        objCurrencyManager.Position -= 1

        'Wyświetlenie aktualnego rekordu.
        ShowPosition()
    End Sub

    Private Sub btnMoveNext_Click(ByVal sender As Object, _
                ByVal e As System.EventArgs) Handles btnMoveNext.Click
        'Przejście do następnego rekordu.
        objCurrencyManager.Position += 1

        'Wyświetlenie aktualnego rekordu.
        ShowPosition()
    End Sub

    Private Sub btnMoveLast_Click(ByVal sender As Object, _
                ByVal e As System.EventArgs) Handles btnMoveLast.Click
        'Przejście do ostatniego rekordu.
        objCurrencyManager.Position = objCurrencyManager.Count - 1

        'Wyświetlenie aktualnego rekordu.
        ShowPosition()
    End Sub

    Private Sub btnPerformSort_Click(ByVal sender As Object, _
        ByVal e As System.EventArgs) Handles btnPerformSort.Click
        'Określenie wybranej kolumny i ustawienie właściwości
        'Sort obiektu DataView.
        Select Case cboField.SelectedIndex
            Case 0 'Nazwisko.
                objDataView.Sort = "au_lname"
            Case 1 'Imię.
                objDataView.Sort = "au_fname"
            Case 2 'Tytuł książki.
                objDataView.Sort = "title"
            Case 3 'Cena.
                objDataView.Sort = "price"
        End Select

        'Wywołanie zdarzenia Click przycisku btnMoveFirst.
        btnMoveFirst_Click(Nothing, Nothing)

        'Wyświetlenie komunikatu o posortowaniu rekordów.
        ToolStripStatusLabel1.Text = "Rekordy zostały posortowane"
    End Sub

    Private Sub btnPerformSearch_Click(ByVal sender As Object, _
        ByVal e As System.EventArgs) Handles btnPerformSearch.Click
        'Deklaracja zmiennych lokalnych.
        Dim intPosition As Integer

        'Określenie wybranej kolumny i ustawienie właściwości
        'Sort obiektu DataView.
        Select Case cboField.SelectedIndex
            Case 0 'Nazwisko.
                objDataView.Sort = "au_lname"
            Case 1 'Imię.
                objDataView.Sort = "au_fname"
            Case 2 'Tytuł książki.
                objDataView.Sort = "title"
            Case 3 'Cena.
                objDataView.Sort = "price"
        End Select

        'Jeśli przeszukiwane pole to nie price, wtedy…
        If cboField.SelectedIndex < 3 Then
            'Wyszukiwanie nazwiska, imienia lub tytułu.
            intPosition = objDataView.Find(txtSearchCriteria.Text)
        Else
            'W przeciwnym razie wyszukiwanie ceny.
            intPosition = objDataView.Find(CType(txtSearchCriteria.Text, Decimal))
        End If
        If intPosition = -1 Then
            'Wyświetlanie komunikatu z informacją, że nie znaleziono rekordu.
            ToolStripStatusLabel1.Text = "Rekordu nie znaleziono"
        Else
            'W przeciwnym razie należy wyświetlić komunikat, że rekord
            'znaleziono, i przejść do tego rekordu za pomocą obiektu
            'CurrencyManager.
            ToolStripStatusLabel1.Text = "Rekord został znaleziony"
            objCurrencyManager.Position = intPosition
        End If

        'Wyświetlenie aktualnego rekordu.
        ShowPosition()
    End Sub

    Private Sub btnNew_Click(ByVal sender As Object, _
            ByVal e As System.EventArgs) Handles btnNew.Click
        'Czyszczenie pól z tytułem i ceną książki. 
        txtBookTitle.Text = ""
        txtPrice.Text = ""
    End Sub

    Private Sub btnAdd_Click(ByVal sender As Object, _
            ByVal e As System.EventArgs) Handles btnAdd.Click
        'Deklaracja lokalnych zmiennych i obiektów.
        Dim intPosition As Integer, intMaxID As Integer
        Dim strID As String
        Dim objCommand As SqlCommand = New SqlCommand()

        'Zapisanie pozycji aktualnego rekordu.
        intPosition = objCurrencyManager.Position
        'Utworzenie nowego obiektu SqlCommand.
        Dim maxIdCommand As SqlCommand = New SqlCommand _
           ("SELECT MAX(title_id) AS MaxID " & _
            "FROM titles WHERE title_id LIKE 'DM%'", objConnection)

        'Otwarcie połączenia, wykonanie polecenia.
        objConnection.Open()
        Dim maxId As Object = maxIdCommand.ExecuteScalar()

        'Jeśli kolumna MaxID ma wartość null.
        If maxId Is DBNull.Value Then
            'Ustawienie wartości domyślnej – 1000.
            intMaxID = 1000
        Else
            'W przeciwnym razie należy przypisać do zmiennej strID wartość z MaxID.
            strID = CType(maxId, String)
            'Pobranie liczby całkowitej z ciągu znaków.
            intMaxID = CType(strID.Remove(0, 2), Integer)

            'Zwiększanie wartości.
            intMaxID += 1
        End If

        'Na końcu ustawienie nowego ID.
        strID = "DM" & intMaxID.ToString

        'Ustawienie właściwości obiektu SqlCommand.
        objCommand.Connection = objConnection
        objCommand.CommandText = "INSERT INTO titles " & _
            "(title_id, title, type, price, pubdate) " & _
            "VALUES(@title_id,@title,@type,@price,@pubdate);" & _
            "INSERT INTO titleauthor (au_id, title_id) VALUES(@au_id,@title_id)"

        'Dodawanie parametrów dla miejsc na dane z kodu SQL
        'z właściwości CommandText.

        'Parametr dla kolumny title_id.
        objCommand.Parameters.AddWithValue("@title_id", strID)

        'Parametr dla kolumny title.
        objCommand.Parameters.AddWithValue("@title", txtBookTitle.Text)

        'Parametr dla kolumny type.
        objCommand.Parameters.AddWithValue("@type", "Demo")
        'Parametr dla kolumny price.
        objCommand.Parameters.AddWithValue("@price", txtPrice.Text).DbType _
                                      = DbType.Currency

        'Parametr dla kolumny pubdate.
        objCommand.Parameters.AddWithValue("@pubdate", Date.Now)

        'Parametr dla kolumny au_id.
        objCommand.Parameters.AddWithValue _
          ("@au_id", BindingContext(objDataView).Current("au_id"))

        'Wykonanie polecenia SqlCommand w celu wstawienia nowych danych.
        Try
            objCommand.ExecuteNonQuery()
        Catch SqlExceptionErr As SqlException
            MessageBox.Show(SqlExceptionErr.Message)
        End Try

        'Zamykanie połączenia.
        objConnection.Close()

        'Zapełnianie obiektu DataSet i wiązanie pól.
        FillDataSetAndView()
        BindFields()

        'Ustawianie pozycji na nowy rekord.
        objCurrencyManager.Position = intPosition

        'Wyświetlanie aktualnego rekordu.
        ShowPosition()

        'Wyświetlanie komunikatu o dodaniu rekordu.
        ToolStripStatusLabel1.Text = "Rekord został dodany"
    End Sub

    Private Sub btnUpdate_Click(ByVal sender As Object, _
            ByVal e As System.EventArgs) Handles btnUpdate.Click
        'Deklaracja lokalnych zmiennych i obiektów.
        Dim intPosition As Integer
        Dim objCommand As SqlCommand = New SqlCommand()

        'Zapisanie pozycji aktualnego rekordu.
        intPosition = objCurrencyManager.Position

        'Ustawienie właściwości obiektu SqlCommand.
        objCommand.Connection = objConnection
        objCommand.CommandText = "UPDATE titles " & _
                "SET title = @title, price = @price WHERE title_id = @title_id"
        objCommand.CommandType = CommandType.Text

        'Dodawanie parametrów dla miejsc na dane z kodu SQL
        'z właściwości CommandText.

        'Parametr dla pola title.
        objCommand.Parameters.AddWithValue("@title", txtBookTitle.Text)

        'Parametr dla pola price.
        objCommand.Parameters.AddWithValue("@price", txtPrice.Text).DbType _
                                      = DbType.Currency

        'Parametr dla pola title_id.
        objCommand.Parameters.AddWithValue _
          ("@title_id", BindingContext(objDataView).Current("title_id"))

        'Otwarcie połączenia.
        objConnection.Open()

        'Wykonanie polecenia obiektu SqlCommand w celu aktualizacji danych.
        objCommand.ExecuteNonQuery()

        'Zamknięcie połączenia.
        objConnection.Close()

        'Zapełnienie obiektu DataSet i powiązanie pól.
        FillDataSetAndView()
        BindFields()

        'Ustawienie pozycji rekordu na pozycję zapisaną na początku procedury.
        objCurrencyManager.Position = intPosition

        'Wyświetlenie aktualnego rekordu.
        ShowPosition()

        'Wyświetlenie komunikatu z informacją o aktualizacji rekordu.
        ToolStripStatusLabel1.Text = "Rekord został zmodyfikowany"
    End Sub

    Private Sub btnDelete_Click(ByVal sender As Object, _
            ByVal e As System.EventArgs) Handles btnDelete.Click
        'Deklaracja lokalnych zmiennych i obiektów.
        Dim intPosition As Integer
        Dim objCommand As SqlCommand = New SqlCommand()

        'Zapisanie pozycji aktualnego rekordu -1 (ze względu na 
        'usuwany rekord).
        intPosition = Me.BindingContext(objDataView).Position - 1

        'Jeśli pozycja jest niższa niż 0, należy ustawić ją na 0.
        If intPosition < 0 Then
            intPosition = 0
        End If

        'Ustawienie właściwości obiektu Command.
        objCommand.Connection = objConnection
        objCommand.CommandText = "DELETE FROM titleauthor " & _
                "WHERE title_id = @title_id;" & _
                "DELETE FROM titles WHERE title_id = @title_id"
        'Parametr dla pola title_id.
        objCommand.Parameters.AddWithValue _
                      ("@title_id", BindingContext(objDataView).Current("title_id"))

        'Otwarcie połączenia z bazą danych.
        objConnection.Open()

        'Wykonanie polecenia obiektu SqlCommand w celu aktualizacji danych.
        objCommand.ExecuteNonQuery()

        'Zamknięcie połączenia.
        objConnection.Close()

        'Zapełnienie obiektu DataSet i powiązanie pól.
        FillDataSetAndView()
        BindFields()

        'Ustawienie pozycji rekordu na tę zapisaną na początku procedury.
        Me.BindingContext(objDataView).Position = intPosition

        'Wyświetlenie aktualnego rekordu.
        ShowPosition()

        'Wyświetlenie komunikatu o usunięciu rekordu.
        ToolStripStatusLabel1.Text = "Rekord został usunięty"
    End Sub

End Class
