﻿using UnityEngine;
[AddComponentMenu("Playground/Actions/Add Points")]
public class PointsAction : Action
{	
    public int pointsWorth = 1;
    private UIScript userInterface;    
	private void Start()
	{
		// Find the UI in the scene and store a reference for later use
		userInterface = GameObject.FindObjectOfType<UIScript>();
	}
	public override bool ExecuteAction(GameObject dataObject)
	{
		if(userInterface != null)
		{           
                userInterface.AddPoints(0, pointsWorth);
            return true;
		}
		else
		{
			Debug.LogWarning("User Interface prefab has not been found in the scene. The action can't execute!");
			return false;
		}
	}
}
