# printers - create a simple list of printers from the /etc/printcap
#            file on the system.
#
# From
# Teach Yourself UNIX in 24 Hours

set printcap=/etc/printcap
set awkscript=/tmp/awkscript.$$

/bin/rm -f $awkscript

cat << 'EOF' > $awkscript
NF == 2 { split($1, words, "|");
          prname=words[1]
        }
NF > 2  { printf("%-10s %s\n", prname, $0) }
'EOF'

egrep '(^[a-zA-Z]|:wi)' $printcap | \
  sed 's/:/ /g' | \
  awk -f $awkscript | \
  sed 's/wi=//;s/wk=/(/;s/ $/)/' | \
  more

/bin/rm -f $awkscript

exit 0

