/**                             fget.c                  **/

/** This is intended to be an easy way to copy files from a remote
    anonymous FTP archive site to your local system.  The format is

        fget host:filename {localfilename}

    "host" can be any Internet hostname, and "filename" must be a
    complete file specifier, including all path information as
    needed. If no "localfilename" is specified, then the file
    is saved under the same name in your own directory. If,
    instead, you use '-' as a filename, it sends the file to
    stdout instead.

    If no path information is specified, then the program invokes an
    "ls" on the remote machine instead: a second argument specifies
    the directory to examine, so "fget netcom.com /etc" will
    result in a listing of the "/etc" directory.

    This program is included in "Teach Yourself UNIX In 24 Hours", a
    new edition of the classic introduction to UNIX from SAMS.net.

    (C) Copyright 1998, Dave Taylor.  All Rights Reserved.
***/

#include "fget.h"

main(argc, argv)
int argc;
char **argv;
{
        FILE *fd;
        char buffer[SLEN], username[NLEN], hostname[NLEN];
        char remotehost[SLEN], remotefile[SLEN], localfname[SLEN];

        if (argc < 2) usage();  /* too few args: usage and quit */

        splitword(argv[1], remotehost, remotefile);     /* split host/file */

        if (argc == 2) strcpy(localfname, basename_of(remotefile));
        else           strcpy(localfname, argv[2]);

        initialize(username, hostname); /* get username and local host */

        if ((fd = fopen(TEMPFILE, "w")) == NULL) {
          fprintf(stderr,
             "Couldn't open tempfile '%s': move into your home directory?\n",
             TEMPFILE);
          exit(1);
        }

        /** now build the information to hand to ftp in the temp file **/

        fprintf(fd, "ascii\nuser %s %s@%s\n", ANONFTP, username, hostname);

        if (strlen(remotefile) == 0) {
          if (strlen(localfname) > 0)           /* directory specified? */
            fprintf(fd, "cd %s\n", localfname); /*     add 'cd' command */
          fprintf(fd, "dir\n");            
        }
        else    /* get a file from the remote site */
          fprintf(fd, "get %s %s\n", remotefile, localfname);

        fprintf(fd, "bye\n");

        fclose(fd);

        /* the input file is built, now to hand it to 'ftp' */

        sprintf(buffer, "ftp -n %s < %s; rm %s", remotehost,TEMPFILE,TEMPFILE);

        exit(system(buffer));
}
