#!/usr/bin/perl

&read_exchange_rate;	 # read exchange rate into memory

# now let's cycle, asking the user for input...

print "Please enter the amount, appending the first letter of the name of\n";
print "the currency that you're using (franc, yen, deutschmark, pound) -\n";
print "the default value is US dollars.\n\n";
print "Amount: ";

while (<STDIN>) {

  ($amnt,$curr) = &breakdown(chop($_));

  $baseval = $amnt * (1/$rateof{$curr});

  printf("%2.2f USD, ", $baseval * $rateof{'U'});
  printf("%2.2f Franc, ", $baseval * $rateof{'F'});
  printf("%2.2f DM, ", $baseval * $rateof{'D'});
  printf("%2.2f Yen, and ", $baseval * $rateof{'Y'});
  printf("%2.2f Pound\n\nAmount: ", $baseval * $rateof{'P'});
}

sub breakdown {
   @line = split(" ", $_);

   $amnt = $line[0];
   if ($#line == 1) {
     $curr = $line[1];
     $curr =~ tr/a-z/A-Z/;         # uppercase
     $curr = substr($curr, 0, 1);  # first char only
   } else { $curr = "U"; }
   return ($amnt, $curr);
}

sub read_exchange_rate {
  open(EXCHRATES, "<exchange.db") || 
    die "Can't find current exchange rates.\n";

  while ( <EXCHRATES> ) {
    chop; split;
    $curr = @_[0];
    $val  = @_[1];
    $rateof{$curr} = $val;
  }
  close(EXCHRATE);
}
