﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

// Zamienia jeden sprajt innym. Na przykład, skarb zmienia się 
// ze sprajtu 'skarb dostępny' na sprajt 'skarb nie odstępny'
public class SpriteSwapper : MonoBehaviour {


	// Sprajt, który należy wyświetlić
	public Sprite spriteToUse;

	// Obiekt SpriteRenderer, który ma użyc nowego sprajtu
	public SpriteRenderer spriteRenderer;

	// Początkowo wyświetlany sprajt; właściwość używana 
	// w momencie wywołania metody ResetSprite
	private Sprite originalSprite;

	// Metoda podmienia sprajty
	public void SwapSprite() {

		// Jeśli ten sprajt jest inny od aktualnie wyświetlonego...
		if (spriteToUse != spriteRenderer.sprite) {

			// Zapisujemy dotychczasowy sprajt we właściwości originalSprite
			originalSprite = spriteRenderer.sprite;

			// I wyświetlamy nowy używając do tego obiektu SpriteRenderer
			spriteRenderer.sprite = spriteToUse;
		}
	}

	// Ponownie wyświetlany pierwotny sprajt
	public void ResetSprite() {

		// Jeśli poprzedni sprajt jest dostępny...
		if (originalSprite != null) {
			// ... wyświetlamy go używając obiektu SpriteRenderer
			spriteRenderer.sprite = originalSprite;
		}
	}
}
