﻿using UnityEngine;
using System.Collections;

// Ta klasa pozwala innym obiektom odwoływać się do jednego 
// współużytkowanego obiektu. Jest ona używana przez klasy 
// GameManager oraz InputManager.

// Aby użyć tej klasy należy zdefiniować jej klasę pochodną,
// w sposób przedstawiony na poniższym przykładzie:
// public class MyManager : Singleton<MyManager>  {  }

// Do tak utworzonego wspólnego obiektu singletona będzie można
// odwoływać się w następujący sposób:
// MyManager.instance.DoSomething();

public class Singleton<T> : MonoBehaviour where T : MonoBehaviour
{

	// Pojedyncza istniejąca instanacja tej klasy
	private static T _instance;

	// Metoda umożliwiająca dostęp do singletona. Podczas jej pierwszego 
	// wywołania zostanie określona wartość składowej _instance. Jeśli 
	// nie uda się znaleźć odpowiedniego obiektu, metoda zarejestruje błąd.
	public static T instance {
		get {
			// Składowa _instancje już została ustawiona...
			if (_instance == null)
			{
				// Próbujemy odszukać obiekt
				_instance = FindObjectOfType<T>();    


				// Jeśli nie uda się go odnaleźć zgłaszamy błąd
				if (_instance == null) {
					Debug.LogError("Nie można znaleźć obiektu tyou " + typeof(T) + "!");
				}
			}

			// Zwracamy instancję, dzięki czemu będzie można jej używać!
			return _instance;
		}
	}
}
