﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

// Przesuwa obiekt ze stałą prędkością i usuwa go po określonym czasie
public class Shot : MonoBehaviour {

	// Prędkość za jaką strzał będzie się poruszał
	public float speed = 100.0f;

	// Liczba sekund, po których upłynięciu strzał zostanie usunięty
	public float life = 5.0f;

	void Start() {
		// Usuwamy obiekt po upłynięciu zadanej liczby sekund (life)
		Destroy(gameObject, life);
	}

	void Update () {
		// Przesuwamy obiekt do przodu ze stałą prędkością
		transform.Translate(Vector3.forward * speed  * Time.deltaTime);
	}
}
