﻿// **** Autor: Jacek Ross - games@ejr.com.pl
// **** Plik jest czescia projektu SymulatorZielarza stworzonego na potrzeby ksiazki "Unity i C#. Praktyka programowania gier" wyd. Helion 2020 oraz czescia kodu gry SymulatorZielarza wydanej w serwisie Steam, wiecej info: http://ejr.com.pl
// **** Dozwolone użycie pod licencją CC0 1.0 (public domain). 
// **** Jeżeli modyfikujesz niniejszy plik - umiesc w nim informacje o tym, ze zawartosc odbiega od oryginalu albo usun informacje o autorze

// **** Author: Jacek Ross - games@ejr.com.pl
// **** This file is a part of SymulatorZielarza project created for book "Unity i C#. Praktyka programowania gier" published by Helion 2020 and a part of source of game SymulatorZielarza published on Steam, more info: http://ejr.com.pl
// **** Usage permission under CC0 1.0 license (public domain). 
// **** If you modified this file - put here an information about that the content of file is modified and diffrent than the original, or delete info about original author

using UnityEngine;
using System.Collections.Generic;
using System;

namespace ZielarzSilnik
{
    public class InformacjaAktywnegoPrzedmiotu
    {
        public int Identyfikator { get; set; }
        public float OstatniaPozycjaX { get; set; }
        public float OstatniaPozycjaY { get; set; }
        public float OstatniaPozycjaZ { get; set; }
        public string NazwaSzablonu { get; set; }
        public GameObject UtworzonyObiekt { get; set; }
    }
    public class MenedzerAktywnychPrzedmiotow: MonoBehaviour
    {
        public static MenedzerAktywnychPrzedmiotow Instancja { get; private set; }
        public const float CZASREKALKULACJI = 0.54f;       //jak często przetwarzać tablicę obiektów [s.]
        public const float MAKSYMALNAWIDOCZNOSCAKTYWNYCH = 40;      //z jakiej odleglosci obiekty mają być widoczne [m.]
        private int _kolejnyUnikatowyIdentyfikator = 0;
        private Dictionary<int, InformacjaAktywnegoPrzedmiotu> _aktywnePrzedmioty;  //klucz jest unikalnym identyfikatorem a wartość strukturą informacyjną
        private List<int> _doPokazania, _doUkrycia;
        private float _licznikCzasu;

        public void OdczytajGre()
        {
            _kolejnyUnikatowyIdentyfikator = MenedzerGry.InstancjaMenedzeraGry.OdczytajZmiennaInt("sm_ukey");
            int liczbaRekordow = MenedzerGry.InstancjaMenedzeraGry.OdczytajZmiennaInt("sm_recs");
            for (int i = 0; i < liczbaRekordow; i++)
            {
                int id = MenedzerGry.InstancjaMenedzeraGry.OdczytajZmiennaInt("sm_uid_" + i);
                string aPrefab = MenedzerGry.InstancjaMenedzeraGry.OdczytajZmiennaString("sm_pr_" + i);
                float posX = MenedzerGry.InstancjaMenedzeraGry.OdczytajZmiennaFloat("sm_px_" + i);
                float posY = MenedzerGry.InstancjaMenedzeraGry.OdczytajZmiennaFloat("sm_py_" + i);
                float posZ = MenedzerGry.InstancjaMenedzeraGry.OdczytajZmiennaFloat("sm_pz_" + i);
                InformacjaAktywnegoPrzedmiotu ai = new InformacjaAktywnegoPrzedmiotu() { Identyfikator = id, NazwaSzablonu = aPrefab, OstatniaPozycjaX = posX, OstatniaPozycjaY = posY, OstatniaPozycjaZ = posZ, UtworzonyObiekt = null};
                if(!_aktywnePrzedmioty.ContainsKey(id))
                    _aktywnePrzedmioty.Add(id, ai);
            }
        }
        public void ZapiszGre()
        {
            int biezacyIndeksZapisu = 0;
            foreach(int id in _aktywnePrzedmioty.Keys)
            {
                InformacjaAktywnegoPrzedmiotu info = _aktywnePrzedmioty[id];
                MenedzerGry.InstancjaMenedzeraGry.ZapiszZmienna("sm_uid_" + biezacyIndeksZapisu, info.Identyfikator);
                MenedzerGry.InstancjaMenedzeraGry.ZapiszZmienna("sm_pr_" + biezacyIndeksZapisu, info.NazwaSzablonu);
                if(info.UtworzonyObiekt != null)
                {
                    MenedzerGry.InstancjaMenedzeraGry.ZapiszZmienna("sm_px_" + biezacyIndeksZapisu, info.UtworzonyObiekt.transform.position.x );
                    MenedzerGry.InstancjaMenedzeraGry.ZapiszZmienna("sm_py_" + biezacyIndeksZapisu, info.UtworzonyObiekt.transform.position.y );
                    MenedzerGry.InstancjaMenedzeraGry.ZapiszZmienna("sm_pz_" + biezacyIndeksZapisu, info.UtworzonyObiekt.transform.position.z );
                } else
                {
                    MenedzerGry.InstancjaMenedzeraGry.ZapiszZmienna("sm_px_" + biezacyIndeksZapisu, info.OstatniaPozycjaX );
                    MenedzerGry.InstancjaMenedzeraGry.ZapiszZmienna("sm_py_" + biezacyIndeksZapisu, info.OstatniaPozycjaY );
                    MenedzerGry.InstancjaMenedzeraGry.ZapiszZmienna("sm_pz_" + biezacyIndeksZapisu, info.OstatniaPozycjaZ);
                }
                biezacyIndeksZapisu++;
            }
            MenedzerGry.InstancjaMenedzeraGry.ZapiszZmienna("sm_recs", biezacyIndeksZapisu);
            MenedzerGry.InstancjaMenedzeraGry.ZapiszZmienna("sm_ukey", _kolejnyUnikatowyIdentyfikator);
        }

        //użyj tej funkcji gdy aktywny przedmiot jest pierwszy raz tworzony, np. przez generator
        public GameObject UtworzNowyAktywnyPrzedmiot(string nazwaWzorca, Vector3 nowaPozycja)
        {
            GameObject stworzonyObiektSceny = WewnetrznaGeneracja(nazwaWzorca, nowaPozycja);
            AktywnyObiekt stworzonyObiektAO = stworzonyObiektSceny.GetComponent<AktywnyObiekt>();
            if (stworzonyObiektAO == null)
                Debug.LogError(nazwaWzorca + "nie posiada AktywnyObiekt");
            else
            {
                stworzonyObiektAO.Identyfikator = PodajNastepnyUnikatowyIdentyfikator();
                InformacjaAktywnegoPrzedmiotu aoi = new InformacjaAktywnegoPrzedmiotu { Identyfikator = stworzonyObiektAO.Identyfikator, NazwaSzablonu = nazwaWzorca, OstatniaPozycjaX = 0, OstatniaPozycjaY = 0, OstatniaPozycjaZ = 0, UtworzonyObiekt = stworzonyObiektSceny };
                _aktywnePrzedmioty.Add(stworzonyObiektAO.Identyfikator, aoi);
                stworzonyObiektSceny.SetActive(true);
                return stworzonyObiektSceny;
            }
            return null;
        }     
        //odrejestrowanie, jest równoważne ze śmiercią obiektu, przestanie być śledzony przez menedżera
        public void UsunAktywnyPrzedmiot(AktywnyObiekt ao)
        {
            if (ao != null && _aktywnePrzedmioty.ContainsKey(ao.Identyfikator))
                _aktywnePrzedmioty.Remove(ao.Identyfikator);
        }
        //rejestruje przedmiot utworzony przez inną klasę
        public void DodajAktywnyPrzedmiot(AktywnyObiekt ao)
        {
            ao.Identyfikator = PodajNastepnyUnikatowyIdentyfikator();
            InformacjaAktywnegoPrzedmiotu aoi = new InformacjaAktywnegoPrzedmiotu { Identyfikator = ao.Identyfikator, NazwaSzablonu = ao.name, OstatniaPozycjaX = ao.transform.position.x, OstatniaPozycjaY = ao.transform.position.y, OstatniaPozycjaZ = ao.transform.position.z, UtworzonyObiekt = ao.gameObject };
            _aktywnePrzedmioty.Add(ao.Identyfikator, aoi);
        }
        //zwraca informację mówiącą czy na listach menedżera istnieje aktywny przedmiot o podanym identyfikatorze
        public bool CzyIstniejeAktywnyPrzedmiot(int identyfikator)
        {
            return _aktywnePrzedmioty.ContainsKey(identyfikator);
        }

        private void PrzeliczWidocznosc()
        {
            _doPokazania.Clear();
            _doUkrycia.Clear();
            foreach (InformacjaAktywnegoPrzedmiotu aoi in _aktywnePrzedmioty.Values)
            {
                float objX = aoi.OstatniaPozycjaX;
                float objZ = aoi.OstatniaPozycjaZ;
                if (aoi.UtworzonyObiekt != null)
                {
                    objX = aoi.UtworzonyObiekt.transform.position.x;
                    objZ = aoi.UtworzonyObiekt.transform.position.z;
                }
                float playerWorldX = Camera.main.transform.position.x;
                float playerWorldZ = Camera.main.transform.position.z;
                bool czyPoiwnienBycWidoczny = objX > playerWorldX - MAKSYMALNAWIDOCZNOSCAKTYWNYCH && objX < playerWorldX + MAKSYMALNAWIDOCZNOSCAKTYWNYCH && objZ > playerWorldZ - MAKSYMALNAWIDOCZNOSCAKTYWNYCH && objZ < playerWorldZ + MAKSYMALNAWIDOCZNOSCAKTYWNYCH ;
                if (czyPoiwnienBycWidoczny && aoi.UtworzonyObiekt == null)
                   _doPokazania.Add(aoi.Identyfikator);
                else if (!czyPoiwnienBycWidoczny && aoi.UtworzonyObiekt != null)
                    _doUkrycia.Add(aoi.Identyfikator);
            }
            foreach (int uid in _doPokazania)
                PokazObiekt(_aktywnePrzedmioty[uid]);
            foreach (int uid in _doUkrycia)
                UkryjObiekt(_aktywnePrzedmioty[uid]);
        }

        private void UkryjObiekt(InformacjaAktywnegoPrzedmiotu aoi)
        {
            aoi.OstatniaPozycjaX = aoi.UtworzonyObiekt.transform.position.x;
            aoi.OstatniaPozycjaY = aoi.UtworzonyObiekt.transform.position.y;
            aoi.OstatniaPozycjaZ = aoi.UtworzonyObiekt.transform.position.z;
            PulaAktywnychPrzedmiotow.Instancja.ZwolnijObiekt( aoi.UtworzonyObiekt);
            aoi.UtworzonyObiekt = null;
        }
        private void PokazObiekt(InformacjaAktywnegoPrzedmiotu aoi)
        {
            Vector3 nowaPozycja = new Vector3(aoi.OstatniaPozycjaX, aoi.OstatniaPozycjaY, aoi.OstatniaPozycjaZ);
            if (aoi.NazwaSzablonu == null || aoi.NazwaSzablonu == "")
                Debug.LogError("aoi.prefabName is null");
            else
            {
                GameObject stworzonyObiekt = WewnetrznaGeneracja(aoi.NazwaSzablonu, nowaPozycja);
                AktywnyObiekt ao = stworzonyObiekt.GetComponent<AktywnyObiekt>();
                if (ao == null)
                    Debug.LogError(aoi.NazwaSzablonu + " nie posiada AktywnyObiekt");
                else
                {
                    ao.Identyfikator = aoi.Identyfikator;
                    aoi.UtworzonyObiekt = stworzonyObiekt;
                }
            }
        }
        private int PodajNastepnyUnikatowyIdentyfikator()
        {
            _kolejnyUnikatowyIdentyfikator++;
            MenedzerGry.InstancjaMenedzeraGry.ZapiszZmienna("sm_ukey", _kolejnyUnikatowyIdentyfikator);
            return _kolejnyUnikatowyIdentyfikator;
        }
        private GameObject WewnetrznaGeneracja(string nazwaObiektu, Vector3 nowaPozycja)
        {
            GameObject stworzonyObiekt = PulaAktywnychPrzedmiotow.Instancja.PodajObiekt( nazwaObiektu);
            if (stworzonyObiekt.GetComponent<AktywnyObiekt>() == null)
                Debug.LogError(nazwaObiektu + " nie posiada komponentu AktywnyObiekt");
            stworzonyObiekt.transform.parent = transform;
            stworzonyObiekt.transform.position = nowaPozycja;
            return stworzonyObiekt;
        }
        private void Start()
        {
            _aktywnePrzedmioty = new Dictionary<int, InformacjaAktywnegoPrzedmiotu>();
            _doUkrycia = new List<int>();
            _doPokazania = new List<int>();
            _licznikCzasu = CZASREKALKULACJI;
        }
        private void Update()
        {
            _licznikCzasu -= Time.deltaTime;
            if (_licznikCzasu < 0)
            {
                PrzeliczWidocznosc();
                _licznikCzasu = CZASREKALKULACJI;
            }
        }
        private void Awake()
        {
            if (Instancja != null && Instancja != this)
                throw new Exception("Niedozwolone tworzenie kolejnej kopii klasy MenedzerAktywnychPrzedmiotow");
            Instancja = this;

        }
    }
}