﻿// **** Autor: Jacek Ross - games@ejr.com.pl
// **** Plik jest czescia projektu SymulatorZielarza stworzonego na potrzeby ksiazki "Unity i C#. Praktyka programowania gier" wyd. Helion 2020 oraz czescia kodu gry SymulatorZielarza wydanej w serwisie Steam, wiecej info: http://ejr.com.pl
// **** Dozwolone użycie pod licencją CC0 1.0 (public domain). 
// **** Jeżeli modyfikujesz niniejszy plik - umiesc w nim informacje o tym, ze zawartosc odbiega od oryginalu albo usun informacje o autorze

// **** Author: Jacek Ross - games@ejr.com.pl
// **** This file is a part of SymulatorZielarza project created for book "Unity i C#. Praktyka programowania gier" published by Helion 2020 and a part of source of game SymulatorZielarza published on Steam, more info: http://ejr.com.pl
// **** Usage permission under CC0 1.0 license (public domain). 
// **** If you modified this file - put here an information about that the content of file is modified and diffrent than the original, or delete info about original author

using SymulatorZielarza_WarstwaAndroid;
using SymulatorZielarza_WarstwaWinPC;
using SymulatorZielarza_WarstwaWinVR;
using UnityEngine;

namespace SymulatorZielarza_WarstwaBazowa
{
    public enum Platforma { WinPC, WinVR, Android}

    public class SelektorPlatformy : MonoBehaviour
    {
        public Platforma PlatformaDomyslna;        
        public IKonfiguratorSceny UtworzKonfiguratorSceny()
        {
            if (PlatformaDomyslna == Platforma.WinPC && System.Environment.GetCommandLineArgs().Length > 1 && System.Environment.GetCommandLineArgs()[1] == "WinVR")
                PlatformaDomyslna = Platforma.WinVR;
            IKonfiguratorSceny konfigurator = null;
            switch(PlatformaDomyslna)
            {
                case Platforma.WinPC:
                    konfigurator = new KonfiguratorScenyWinPC();
                    break;
                case Platforma.WinVR:
                    konfigurator = new KonfiguratorScenyWinVR();
                    break;
                case Platforma.Android:
                    konfigurator = new KonfiguratorScenyAndroid();
                    break;
                default:
                    konfigurator = new KonfiguratorScenyWinPC();
                    break;
            }
            return konfigurator;
        }
        public IStanGry UtworzMenedzerStanuGry()
        {
            switch (PlatformaDomyslna)
            {
                case Platforma.WinPC:
                    return new MenedzerStanuGryWinPC();
                case Platforma.WinVR:
                    return new MenedzerStanuGryWinPC();
                case Platforma.Android:
                    return new MenedzerStanuGryAndroid();
                default:
                    return new MenedzerStanuGryWinPC();
            }
        }
        public IMenedzerWejscia UtworzMenedzerWejscia()
        {
            switch (PlatformaDomyslna)
            {
                case Platforma.WinPC:
                    return GetComponent<MenedzerWejsciaWinPC>();
                case Platforma.WinVR:
                    return GetComponent<MenedzerWejsciaWinVR>();
                case Platforma.Android:
                    return GetComponent<MenedzerWejsciaAndroid>();
                default:
                    return GetComponent<MenedzerWejsciaWinPC>();
            }
        }
        public string PodajPakietZasobow()
        {
            switch (PlatformaDomyslna)
            {
                case Platforma.WinPC:
                    return "klientwindows";
                case Platforma.WinVR:
                    return "klientwindows";
                case Platforma.Android:
                    return "klientandroid";
                default:
                    return "klientwindows";
            }

        }

    }
}