﻿// **** Autor: Jacek Ross - games@ejr.com.pl
// **** Plik jest czescia projektu SymulatorZielarza stworzonego na potrzeby ksiazki "Unity i C#. Praktyka programowania gier" wyd. Helion 2020 oraz czescia kodu gry SymulatorZielarza wydanej w serwisie Steam, wiecej info: http://ejr.com.pl
// **** Dozwolone użycie pod licencją CC0 1.0 (public domain). 
// **** Jeżeli modyfikujesz niniejszy plik - umiesc w nim informacje o tym, ze zawartosc odbiega od oryginalu albo usun informacje o autorze

// **** Author: Jacek Ross - games@ejr.com.pl
// **** This file is a part of SymulatorZielarza project created for book "Unity i C#. Praktyka programowania gier" published by Helion 2020 and a part of source of game SymulatorZielarza published on Steam, more info: http://ejr.com.pl
// **** Usage permission under CC0 1.0 license (public domain). 
// **** If you modified this file - put here an information about that the content of file is modified and diffrent than the original, or delete info about original author


using System.Collections.Generic;
using System;
using System.Collections;
using UnityEngine;
using UnityEngine.Networking;


public class MenedzerPakietowZasobow: MonoBehaviour
{
    public bool CzyLaduje { get { return _czyLaduje || _pakietyDoZaladowania.Count > 0; } }
    public static MenedzerPakietowZasobow Instancja { get; private set; }

    private Dictionary<string, AssetBundle> _zaladowanePakiety;
    private Queue<string> _pakietyDoZaladowania;
    private Dictionary<string, List<string>> _nazwyZasobow;       //Nazwy wszystkich załadowanych zasobów, jedna list zawiera zasoby z jednego pakietu, a klucz słownika jest nazwą pakietu
    private bool _czyLaduje;

    public void Inicjuj()
    {
       _zaladowanePakiety = new Dictionary<string, AssetBundle>();
       _pakietyDoZaladowania = new Queue<string>();
        _nazwyZasobow = new Dictionary<string, List<string>>();
        _czyLaduje = false;
        foreach(AssetBundle ab in AssetBundle.GetAllLoadedAssetBundles())
        {
            _zaladowanePakiety.Add(ab.name, ab);
            ZaladujZawartoscPakietu(ab.name);
        }
    }
    public void DodajPakietDoKolejkiLadowania(string nazwaPakietu)
    {
        if (!CzyPakietJestZaladowany(nazwaPakietu) && !_pakietyDoZaladowania.Contains(nazwaPakietu) && !_zaladowanePakiety.ContainsKey(nazwaPakietu))
            _pakietyDoZaladowania.Enqueue(nazwaPakietu);
    }
    public bool CzyPakietJestZaladowany(string nazwaPakietu)
    {
        return _zaladowanePakiety.ContainsKey(nazwaPakietu);
    }
    public void ZwolnijPakiet(string nazwaPakietu)
    {
        if(CzyPakietJestZaladowany(nazwaPakietu))
        {
            AssetBundle ab = _zaladowanePakiety[nazwaPakietu];
            _zaladowanePakiety.Remove(nazwaPakietu);
            ab.Unload(true);
            _nazwyZasobow.Remove(nazwaPakietu);
        }        
    }      
    public AssetBundle PodajPakiet(string nazwa)
    {
        if (CzyPakietJestZaladowany(nazwa.ToLower()))
            return _zaladowanePakiety[nazwa.ToLower()];
        return null;
    }
    //zwraca pakiet zawierający zasób o podanej nazwie, albo null jeśli nazwa zasobu nie jest znaleziona w żadnym załadowanym pakiecie (jeśli więcej niż jeden pakiet zawiera dany zasób - będzie podany pierwszy znaleziony pakiet)
    public AssetBundle ZnajdzPakietZZasobem(string nazwaZasobu)
    {
        nazwaZasobu = nazwaZasobu.ToLower();
        foreach (string bundName in _nazwyZasobow.Keys)
            if (_nazwyZasobow[bundName].Contains(nazwaZasobu))
                return _zaladowanePakiety[bundName];
        return null;
    }
    public IEnumerator RozpocznijLadowaniePakietu(string nazwaPakietu)
    {
        string uri = Application.streamingAssetsPath + "/" + nazwaPakietu;
        Debug.Log(" start loading AB " + uri);
        UnityWebRequest zlecenie = UnityWebRequestAssetBundle.GetAssetBundle(uri);
        zlecenie.chunkedTransfer = false;
        yield return zlecenie.SendWebRequest();
        if (zlecenie.isNetworkError || zlecenie.isHttpError)
        {
            Debug.LogError("Błąd ładowania pakietu " + uri + " błąd: " + zlecenie.error);
        }
        else
        {
            _zaladowanePakiety.Add(nazwaPakietu, DownloadHandlerAssetBundle.GetContent(zlecenie));
            ZaladujZawartoscPakietu(nazwaPakietu);
        }
        _czyLaduje = false;
    }


    private void Awake()
    {
        if (Instancja != null && Instancja != this)
            throw new Exception("Niedozwolone tworzenie kolejnej kopii klasy MenedzerPakietowZasobow");
        Instancja = this;
        DontDestroyOnLoad(this.gameObject);
        Inicjuj();
    }
    private void Update()
    {
        if(!_czyLaduje && _pakietyDoZaladowania.Count > 0)
        {
            string toLoadName = _pakietyDoZaladowania.Dequeue();
            _czyLaduje = true;
            StartCoroutine(RozpocznijLadowaniePakietu(toLoadName));            
        }
    }
    

    private void ZaladujZawartoscPakietu(string nazwaPakietu)
    {
        string[] wszystkieNazwy = _zaladowanePakiety[nazwaPakietu].GetAllAssetNames();
        for (int i = 0; i < wszystkieNazwy.Length; i++)
        {
            wszystkieNazwy[i] = wszystkieNazwy[i].Substring(wszystkieNazwy[i].LastIndexOf('/') + 1);
        }
        List<String> listaNazw = new List<string>();
        listaNazw.AddRange(wszystkieNazwy);
        _nazwyZasobow.Add(nazwaPakietu, listaNazw);
    }   
}

