﻿// **** Autor: Jacek Ross - games@ejr.com.pl
// **** Plik jest czescia projektu SymulatorZielarza stworzonego na potrzeby ksiazki "Unity i C#. Praktyka programowania gier" wyd. Helion 2020 oraz czescia kodu gry SymulatorZielarza wydanej w serwisie Steam, wiecej info: http://ejr.com.pl
// **** Dozwolone użycie pod licencją CC0 1.0 (public domain). 
// **** Jeżeli modyfikujesz niniejszy plik - umiesc w nim informacje o tym, ze zawartosc odbiega od oryginalu albo usun informacje o autorze

// **** Author: Jacek Ross - games@ejr.com.pl
// **** This file is a part of SymulatorZielarza project created for book "Unity i C#. Praktyka programowania gier" published by Helion 2020 and a part of source of game SymulatorZielarza published on Steam, more info: http://ejr.com.pl
// **** Usage permission under CC0 1.0 license (public domain). 
// **** If you modified this file - put here an information about that the content of file is modified and diffrent than the original, or delete info about original author

using SymulatorZielarza_WarstwaBazowa;
using UnityEngine;

namespace SymulatorZielarza_WarstwaAndroid
{
    public class MenedzerWejsciaAndroid : MonoBehaviour, IMenedzerWejscia
    {
        private event DelegatLogicznejAkcji ZdarzenieLogicznejAkcji;

        public void NasluchujWejscie(DelegatLogicznejAkcji sluchacz)
        {
            ZdarzenieLogicznejAkcji += sluchacz;
        }
        public void ZakonczNasluch(DelegatLogicznejAkcji sluchacz)
        {
            ZdarzenieLogicznejAkcji -= sluchacz;
        }             

        public void ZmianaSzybkosciCzasu()
        {
            ZdarzenieLogicznejAkcji?.Invoke(LogicznaAkcja.CzasJedenKlik);
            ZdarzenieLogicznejAkcji?.Invoke(LogicznaAkcja.Dowolna);
        }
        void Update()
        {
            if (Input.GetMouseButtonDown(0))
            {
                ZdarzenieLogicznejAkcji?.Invoke(LogicznaAkcja.Interakcja);
                ZdarzenieLogicznejAkcji?.Invoke(LogicznaAkcja.Dowolna);                
            }
            if (UnityStandardAssets.CrossPlatformInput.CrossPlatformInputManager.GetButtonDown("Rzemieslnictwo"))
            {                
                ZdarzenieLogicznejAkcji?.Invoke(LogicznaAkcja.UruchomRzemieslnictwo);
                ZdarzenieLogicznejAkcji?.Invoke(LogicznaAkcja.Dowolna);
            }
            if (UnityStandardAssets.CrossPlatformInput.CrossPlatformInputManager.GetButtonDown("Plecak"))
            {
                ZdarzenieLogicznejAkcji?.Invoke(LogicznaAkcja.RozwinPlecak);
                ZdarzenieLogicznejAkcji?.Invoke(LogicznaAkcja.Dowolna);
            }
            if (UnityStandardAssets.CrossPlatformInput.CrossPlatformInputManager.GetButtonDown("Menu"))
            {
                ZdarzenieLogicznejAkcji?.Invoke(LogicznaAkcja.WyjdzDoMenu);
                ZdarzenieLogicznejAkcji?.Invoke(LogicznaAkcja.Dowolna);
            }
            if (UnityStandardAssets.CrossPlatformInput.CrossPlatformInputManager.GetButtonDown("Wyrzuc"))
            {
                ZdarzenieLogicznejAkcji?.Invoke(LogicznaAkcja.WyrzucPrzedmiot);
                ZdarzenieLogicznejAkcji?.Invoke(LogicznaAkcja.Dowolna);
            }
            if (UnityStandardAssets.CrossPlatformInput.CrossPlatformInputManager.GetButtonDown("PlecakWLewo"))
            {
                ZdarzenieLogicznejAkcji?.Invoke(LogicznaAkcja.PlecakWLewo);
                ZdarzenieLogicznejAkcji?.Invoke(LogicznaAkcja.Dowolna);
            }
            if (UnityStandardAssets.CrossPlatformInput.CrossPlatformInputManager.GetButtonDown("PlecakWPrawo"))
            {
                ZdarzenieLogicznejAkcji?.Invoke(LogicznaAkcja.PlecakWPrawo);
                ZdarzenieLogicznejAkcji?.Invoke(LogicznaAkcja.Dowolna);
            }
            if (UnityStandardAssets.CrossPlatformInput.CrossPlatformInputManager.GetButtonDown("Pomoc"))
            {
                ZdarzenieLogicznejAkcji?.Invoke(LogicznaAkcja.PrzewodnikDalej);
                ZdarzenieLogicznejAkcji?.Invoke(LogicznaAkcja.Pomoc);
                ZdarzenieLogicznejAkcji?.Invoke(LogicznaAkcja.Dowolna);
            }
            if (UnityStandardAssets.CrossPlatformInput.CrossPlatformInputManager.GetButtonDown("Jump"))
                ZdarzenieLogicznejAkcji?.Invoke(LogicznaAkcja.Dowolna);
        }
    }
}