﻿// **** Autor: Jacek Ross - games@ejr.com.pl
// **** Plik jest czescia projektu SymulatorZielarza stworzonego na potrzeby ksiazki "Unity i C#. Praktyka programowania gier" wyd. Helion 2020 oraz czescia kodu gry SymulatorZielarza wydanej w serwisie Steam, wiecej info: http://ejr.com.pl
// **** Dozwolone użycie pod licencją CC0 1.0 (public domain). 
// **** Jeżeli modyfikujesz niniejszy plik - umiesc w nim informacje o tym, ze zawartosc odbiega od oryginalu albo usun informacje o autorze

// **** Author: Jacek Ross - games@ejr.com.pl
// **** This file is a part of SymulatorZielarza project created for book "Unity i C#. Praktyka programowania gier" published by Helion 2020 and a part of source of game SymulatorZielarza published on Steam, more info: http://ejr.com.pl
// **** Usage permission under CC0 1.0 license (public domain). 
// **** If you modified this file - put here an information about that the content of file is modified and diffrent than the original, or delete info about original author

using UnityEngine;
using UnityStandardAssets.Characters.FirstPerson;

namespace ZielarzSilnik
{
    public class KontrolerGracza: MonoBehaviour
    {
        public const float MAXXBRZEGU = 250;
        public const float MAXZBRZEGU = 250;
        public const float MINXBRZEGU = -250;
        public const float MINZBRZEGU = -250;
        public const float CZESTOSCBADANIA = 4;

        private Vector3 _ostatniaBezpiecznaPozycja;
        private float _licznikCzasu;
        private bool _ruchWylaczony;

        private void Start()
        {
            _licznikCzasu = CZESTOSCBADANIA;
            _ruchWylaczony = false;
        }
        private void Update()
        {
            _licznikCzasu -= Time.deltaTime;
            if(_licznikCzasu <= 0)
            {
                _licznikCzasu = CZESTOSCBADANIA;
                ZbadajBrzegMapy();
            } else 
            if (_ruchWylaczony)
            {
                _ruchWylaczony = false;
                GetComponent<FirstPersonController>().enabled = true;
            }
        }

        private void ZbadajBrzegMapy()
        {           
            if (transform.position.x < MINXBRZEGU || transform.position.x > MAXXBRZEGU || transform.position.z < MINZBRZEGU || transform.position.z > MAXZBRZEGU)
            {
                PrzesunGracza(_ostatniaBezpiecznaPozycja);
                MenedzerUI.Instancja.PokazMaleInfo(TlumaczCiagow.PodajCiag("InfoBrzegowe"));
            }
            else
                _ostatniaBezpiecznaPozycja = gameObject.transform.position;
        }

        public void PrzesunGracza(Vector3 nowaPozycja)
        {
            GetComponent<FirstPersonController>().enabled = false;
            gameObject.transform.position = nowaPozycja;
            _ruchWylaczony = true;            
        }
    }


}
