﻿// **** Autor: Jacek Ross - games@ejr.com.pl
// **** Plik jest czescia projektu SymulatorZielarza stworzonego na potrzeby ksiazki "Unity i C#. Praktyka programowania gier" wyd. Helion 2020 oraz czescia kodu gry SymulatorZielarza wydanej w serwisie Steam, wiecej info: http://ejr.com.pl
// **** Dozwolone użycie pod licencją CC0 1.0 (public domain). 
// **** Jeżeli modyfikujesz niniejszy plik - umiesc w nim informacje o tym, ze zawartosc odbiega od oryginalu albo usun informacje o autorze

// **** Author: Jacek Ross - games@ejr.com.pl
// **** This file is a part of SymulatorZielarza project created for book "Unity i C#. Praktyka programowania gier" published by Helion 2020 and a part of source of game SymulatorZielarza published on Steam, more info: http://ejr.com.pl
// **** Usage permission under CC0 1.0 license (public domain). 
// **** If you modified this file - put here an information about that the content of file is modified and diffrent than the original, or delete info about original author


using System.Collections.Generic;

namespace ZielarzSilnik
{

    public class  Postac
    {
        protected class AtrybutPostaci
        {
            public float Wartosc;
            public float Minimum;
            public float Maksimum;
            public void UstawWartosc(float nowaWartosc)
            {
                Wartosc = nowaWartosc;
                if (Wartosc < Minimum)
                    Wartosc = Minimum;
                if (Wartosc > Maksimum)
                    Wartosc = Maksimum;
            }
        }
        protected Dictionary<string, AtrybutPostaci> _atrybutyPostaci;

        public Postac()
        {
            _atrybutyPostaci = new Dictionary<string, AtrybutPostaci>();
        }

        public float PobierzAtrybut(string nazwa)
        {
            if (_atrybutyPostaci.ContainsKey(nazwa))
                return _atrybutyPostaci[nazwa].Wartosc;
            return 0;
        }

        public void UtworzAtrybut(string nazwa, float wartosc, float minimum, float maksimum)
        {
            if(!_atrybutyPostaci.ContainsKey (nazwa))
                _atrybutyPostaci.Add(nazwa, new AtrybutPostaci() { Wartosc = wartosc, Minimum = minimum, Maksimum = maksimum });
            else
            {
                _atrybutyPostaci[nazwa].Minimum = minimum;
                _atrybutyPostaci[nazwa].Maksimum = maksimum;
                _atrybutyPostaci[nazwa].UstawWartosc(wartosc);
            }
        }
        public void UstawAtrybut(string nazwa, float wartosc)
        {
            if (_atrybutyPostaci.ContainsKey(nazwa))
                _atrybutyPostaci[nazwa].UstawWartosc(wartosc);
            else
                throw new System.Exception("Nieznany atrybut postaci " + nazwa);            
        }
        public void SkasujAtrybut(string nazwa)
        {
            if (_atrybutyPostaci.ContainsKey(nazwa))
                _atrybutyPostaci.Remove(nazwa);
        }
    }
}
