﻿// **** Autor: Jacek Ross - games@ejr.com.pl
// **** Plik jest czescia projektu SymulatorZielarza stworzonego na potrzeby ksiazki "Unity i C#. Praktyka programowania gier" wyd. Helion 2020 oraz czescia kodu gry SymulatorZielarza wydanej w serwisie Steam, wiecej info: http://ejr.com.pl
// **** Dozwolone użycie pod licencją CC0 1.0 (public domain). 
// **** Jeżeli modyfikujesz niniejszy plik - umiesc w nim informacje o tym, ze zawartosc odbiega od oryginalu albo usun informacje o autorze

// **** Author: Jacek Ross - games@ejr.com.pl
// **** This file is a part of SymulatorZielarza project created for book "Unity i C#. Praktyka programowania gier" published by Helion 2020 and a part of source of game SymulatorZielarza published on Steam, more info: http://ejr.com.pl
// **** Usage permission under CC0 1.0 license (public domain). 
// **** If you modified this file - put here an information about that the content of file is modified and diffrent than the original, or delete info about original author

using System.Collections.Generic;

namespace ZielarzSilnik
{
    //Handlarz przechowuje liste przedmiotow w posiadaniu, co godzine losowo wymienia badz dodaje jakis przedmiot i odswieza zloto
    public class Handlarz : Postac
    {
        public int LiczbaPrzedmiotow { get { return _listaPrzedmiotow.Count; } }
        public bool OdswiezanieSklepu { get; set; }         //okresla czy ma byc wlaczone odswiezanie przedmiotow

        public const int MAKSIMUMPRZEDMIOTOW = 8;      //maks. liczba przedmiotow sprzedawanych

        private List<string> _listaPrzedmiotow;
        private int _ostatniaGodzina = 0;
        public Handlarz() : base()
        {
            _listaPrzedmiotow = new List<string>();
            OdczytajGre();
            OdswiezanieSklepu = true;
            SystemDniaNocyPogody.Instancja.ZmianaGodziny += UplynelaGodzina;
            _ostatniaGodzina = SystemDniaNocyPogody.Instancja.Godzina;
            while (_listaPrzedmiotow.Count < 6)
                ZmienLosowyPrzedmiot();
            UtworzAtrybut("Zloto", KonfiguratorGry.OptimumZlotaHandlarza, 0, float.MaxValue);
            OdswiezListePrzedmiotow();
            UplynelaGodzina(0);
        }     
        public string PodajKolejnyPrzedmiot(int indeks)
        {
            if (indeks >= 0 && indeks < LiczbaPrzedmiotow)
                return _listaPrzedmiotow[indeks];
            return null;
        }
        public void ZapiszGre()
        {
            MenedzerGry.InstancjaMenedzeraGry.ZapiszZmienna( "HandlarzZloto", PobierzAtrybut("Zloto"));
            string przedmiotyStr = "";
            foreach (string pojedynczyPrzedmiot in _listaPrzedmiotow)
                przedmiotyStr +=  pojedynczyPrzedmiot + ";";
            MenedzerGry.InstancjaMenedzeraGry.ZapiszZmienna("PrzedmiotyHandlarza", przedmiotyStr);
        }

        //za ile sprzedawca moze zdecydowac sie na zakup podanego przedmiotu
        public int ZaIleKupie(Przedmiot przedmiot)
        {
            if (przedmiot.WewnetrzneDane.Wartosc < 2)
                return 1;
            return (int)(przedmiot.WewnetrzneDane.Wartosc * KonfiguratorGry.RoznicaCenSprzedazy);
        }
        //dodaj przedmiot do listy jesli jest miejsce a jeśli nie to zamień z losowo wybranym przedmiotem
        public void DodajLubZamienPrzedmiot(string nazwaPrzedmiotu)
        {
            if (!MenedzerGry.InstancjaMenedzeraGry.ObiektGracza.ZnaRecepture(nazwaPrzedmiotu))
            {
                if (_listaPrzedmiotow.Count >= MAKSIMUMPRZEDMIOTOW)
                    SkasujAtrybut("Przedmiot" + _listaPrzedmiotow[UnityEngine.Random.Range(0, _listaPrzedmiotow.Count)]);
                UtworzAtrybut("Przedmiot" + nazwaPrzedmiotu, 1, 0, 1);
                OdswiezListePrzedmiotow();
                ZapiszGre();
            }
        }
        //usuń podany przedmiot z listy
        public void UsunPrzedmiot(string nazwaPrzedmiotu)
        {
            for(int i = 0; i < _listaPrzedmiotow.Count; i++ )
                if(_listaPrzedmiotow[i] == nazwaPrzedmiotu)
                    SkasujAtrybut("Przedmiot" + _listaPrzedmiotow[i]);
            OdswiezListePrzedmiotow();
            ZapiszGre();
        }
      
        private void OdswiezListePrzedmiotow()
        {
            _listaPrzedmiotow.Clear();
            foreach (string kluczAtrybutu in _atrybutyPostaci.Keys)
                if (kluczAtrybutu.StartsWith("Przedmiot"))
                    _listaPrzedmiotow.Add(kluczAtrybutu.Replace("Przedmiot", ""));   
        }
        private void UplynelaGodzina(int godzina)
        {
            if (OdswiezanieSklepu)
            {
                float zloto = PobierzAtrybut("Zloto");
                float dodajZlota = 0;
                //zmien złoto w kierunku optymalnego
                if (zloto < KonfiguratorGry.OptimumZlotaHandlarza * 0.9f)
                    dodajZlota = UnityEngine.Random.Range(KonfiguratorGry.OptimumZlotaHandlarza * 0.05f, KonfiguratorGry.OptimumZlotaHandlarza - zloto);
                else if (zloto < KonfiguratorGry.OptimumZlotaHandlarza)
                    dodajZlota = KonfiguratorGry.OptimumZlotaHandlarza - zloto;
                if (zloto > KonfiguratorGry.OptimumZlotaHandlarza * 1.1f)
                    dodajZlota = -UnityEngine.Random.Range(KonfiguratorGry.OptimumZlotaHandlarza * 0.05f, zloto - KonfiguratorGry.OptimumZlotaHandlarza);
                else if (zloto > KonfiguratorGry.OptimumZlotaHandlarza)
                    dodajZlota = KonfiguratorGry.OptimumZlotaHandlarza - zloto;
                UstawAtrybut("Zloto", (int)(zloto + dodajZlota));
                int uplyneloGodzin = SystemDniaNocyPogody.Instancja.Godzina - _ostatniaGodzina;
                if(uplyneloGodzin < 0) 
                   uplyneloGodzin += 24;
                _ostatniaGodzina = SystemDniaNocyPogody.Instancja.Godzina;
                for(int i = 0; i < uplyneloGodzin ; i++)
                    ZmienLosowyPrzedmiot();
                ZapiszGre();
            }
        }
        private void ZmienLosowyPrzedmiot()
        {
             //wylosuj jakiś nowy przedmiot na sprzedaż
             string losowy = MenedzerZielarstwa.Instancja.WylosujPrzedmiot();
             //i jakiś jest maks przedmiotów to zamien jeden losowo wybrany, a jesli nie maks. to dodaj
             if (losowy != null && !_listaPrzedmiotow.Contains(losowy))
                  DodajLubZamienPrzedmiot(losowy);
        }
        private void OdczytajGre()
        {
            UtworzAtrybut("Zloto", MenedzerGry.InstancjaMenedzeraGry.OdczytajZmiennaFloat("HandlarzZloto"), 0, float.MaxValue);
            string przedmiotyStr = MenedzerGry.InstancjaMenedzeraGry.OdczytajZmiennaString("PrzedmiotyHandlarza");
            string[] listaPrzedmiotow = przedmiotyStr.Split(';');
            foreach (string pojedynczyPrzedmiot in listaPrzedmiotow)
                if (pojedynczyPrzedmiot != "" && !_atrybutyPostaci.ContainsKey("Przedmiot" + pojedynczyPrzedmiot))
                    DodajLubZamienPrzedmiot(pojedynczyPrzedmiot);
            OdswiezListePrzedmiotow();
        }

    }
}
