﻿// **** Autor: Jacek Ross - games@ejr.com.pl
// **** Plik jest czescia projektu SymulatorZielarza stworzonego na potrzeby ksiazki "Unity i C#. Praktyka programowania gier" wyd. Helion 2020 oraz czescia kodu gry SymulatorZielarza wydanej w serwisie Steam, wiecej info: http://ejr.com.pl
// **** Dozwolone użycie pod licencją CC0 1.0 (public domain). 
// **** Jeżeli modyfikujesz niniejszy plik - umiesc w nim informacje o tym, ze zawartosc odbiega od oryginalu albo usun informacje o autorze

// **** Author: Jacek Ross - games@ejr.com.pl
// **** This file is a part of SymulatorZielarza project created for book "Unity i C#. Praktyka programowania gier" published by Helion 2020 and a part of source of game SymulatorZielarza published on Steam, more info: http://ejr.com.pl
// **** Usage permission under CC0 1.0 license (public domain). 
// **** If you modified this file - put here an information about that the content of file is modified and diffrent than the original, or delete info about original author


using UnityEngine;
using System.Collections.Generic;
using System.Xml.Linq;
using Dodatki;

namespace ZielarzSilnik
{
    public class TlumaczCiagow
    {
        private const string NAZWAPLIKU = "ciagi";
        private const string SCIEZKA = "Lokalizacja/"; //wzgledem katalogu Assets/Resources

        private static string _folderJezyka = "";
        private static List<string> _nakladki;
        private static Dictionary<string, string> _dane;

        public static string PodajCiag(string nazwa)
        {
            if (_dane == null)              
                Zaladuj();
            if (_dane.ContainsKey(nazwa))
                return _dane[nazwa];
            else
                Debug.LogError("Nie znaleziono ciągu o nazwie: " + nazwa);
            return null;
        }
       
        public static bool ZawieraCiag(string nazwa)
        {
            if (_dane == null)
                Zaladuj();
            return _dane.ContainsKey(nazwa);
        }

        public static void DodajNakladke(string nazwa)
        {
            if (_nakladki == null)
                _nakladki = new List<string>();
            _nakladki.Add(nazwa);
        }

        private static void Zaladuj()
        {
            string KodJezykaSystemu = KonwertujKodJezyka(Application.systemLanguage);
            if (KodJezykaSystemu.Equals("pl"))
                _folderJezyka = "-pl";
            else
                _folderJezyka = "";
            _dane = new Dictionary<string, string>();
            ZaladujZasoby(SCIEZKA + NAZWAPLIKU + _folderJezyka);
            if(_nakladki != null)
                foreach(string nakladka in _nakladki)
                    ZaladujZasoby(SCIEZKA + NAZWAPLIKU + "_" + nakladka + _folderJezyka);
        }



        private static string KonwertujKodJezyka(SystemLanguage jezyk)
        {
            switch (jezyk)
            {
                case SystemLanguage.English: return "en";
                case SystemLanguage.Polish: return "pl";
                default: return "";
            }
        }
        private static void ZaladujZasoby(string zasobXML)
        {
            XDocument dokument = Funkcje.ZaladujZasobXMLJakoDoc(zasobXML, null);
            XElement zawartosc = dokument.Element("ciagi");
            IEnumerable<XElement> nodeList = zawartosc.Descendants("ciag");
            foreach (XElement node in nodeList)
            {
                string nazwa = node.Attribute("nazwa").Value;
                string tekst = node.Value;
                tekst = tekst.Replace("\n", " ");
                tekst = tekst.Replace("\\n", "\n");
                if (nazwa == null)
                    Debug.LogError("ciąg ma wartość null: " + tekst + " w " + zasobXML);
                if (_dane.ContainsKey(nazwa))
                    _dane[nazwa] = tekst;
                else
                    _dane.Add(nazwa, tekst);
            }
        }
    }
}