﻿// **** Autor: Jacek Ross - games@ejr.com.pl
// **** Plik jest czescia projektu SymulatorZielarza stworzonego na potrzeby ksiazki "Unity i C#. Praktyka programowania gier" wyd. Helion 2020 oraz czescia kodu gry SymulatorZielarza wydanej w serwisie Steam, wiecej info: http://ejr.com.pl
// **** Dozwolone użycie pod licencją CC0 1.0 (public domain). 
// **** Jeżeli modyfikujesz niniejszy plik - umiesc w nim informacje o tym, ze zawartosc odbiega od oryginalu albo usun informacje o autorze

// **** Author: Jacek Ross - games@ejr.com.pl
// **** This file is a part of SymulatorZielarza project created for book "Unity i C#. Praktyka programowania gier" published by Helion 2020 and a part of source of game SymulatorZielarza published on Steam, more info: http://ejr.com.pl
// **** Usage permission under CC0 1.0 license (public domain). 
// **** If you modified this file - put here an information about that the content of file is modified and diffrent than the original, or delete info about original author

using UnityEngine;
using UnityStandardAssets.Characters.FirstPerson;
using SymulatorZielarza_WarstwaBazowa;

namespace SymulatorZielarza_WarstwaWinPC
{
    public class KontrolerGraczaWinPC: BazowyKontrolerGracza
    {
        private bool _ruchWylaczony, _wNastepnejKlatceWlaczRuch;
        private Terrain _teren;

        public override void PrzesunGracza(Terrain teren, Vector3 nowaPozycja)
        {
            GetComponent<FirstPersonController>().enabled = false;
            gameObject.transform.position = nowaPozycja;
            _ruchWylaczony = true;            
        }

        private void Awake()
        {
            _ruchWylaczony = false;
            _wNastepnejKlatceWlaczRuch = false;
            _teren = FindObjectOfType<Terrain>();
        }
        private void Update()
        {
            if (_wNastepnejKlatceWlaczRuch)
            {
                _ruchWylaczony = false;
                _wNastepnejKlatceWlaczRuch = false;
                GetComponent<FirstPersonController>().enabled = true;
            }
            else
                if (_ruchWylaczony)
                _wNastepnejKlatceWlaczRuch = true;
            float wysokoscTerenu = _teren.SampleHeight(transform.position);
            if (transform.position.y < wysokoscTerenu)
                PrzesunGracza(_teren, new Vector3(transform.position.x, wysokoscTerenu + 0.01f, transform.position.z));
        }

    }


}
