﻿// **** Autor: Jacek Ross - games@ejr.com.pl
// **** Plik jest czescia projektu SymulatorZielarza stworzonego na potrzeby ksiazki "Unity i C#. Praktyka programowania gier" wyd. Helion 2020 oraz czescia kodu gry SymulatorZielarza wydanej w serwisie Steam, wiecej info: http://ejr.com.pl
// **** Dozwolone użycie pod licencją CC0 1.0 (public domain). 
// **** Jeżeli modyfikujesz niniejszy plik - umiesc w nim informacje o tym, ze zawartosc odbiega od oryginalu albo usun informacje o autorze

// **** Author: Jacek Ross - games@ejr.com.pl
// **** This file is a part of SymulatorZielarza project created for book "Unity i C#. Praktyka programowania gier" published by Helion 2020 and a part of source of game SymulatorZielarza published on Steam, more info: http://ejr.com.pl
// **** Usage permission under CC0 1.0 license (public domain). 
// **** If you modified this file - put here an information about that the content of file is modified and diffrent than the original, or delete info about original author


using System.Collections.Generic;
using System.Xml.Linq;
using UnityEngine;

namespace ZielarzSilnik
{

    //przedmiot ktory moze zawierac rozne substancje leczace/trujace
    public class PrzedmiotLeczniczy
    {
        public string Nazwa;                        // nazwa przedmiotu(identyfikator ciagu nazwy)
        public int CzasDzialania;                   // czas działania (godziny)
        public int PozostalyCzasDzialania;                   // czas działania (godziny)
        public List<Substancja> AktywneSubstancje;  // lista substancji leczniczych (sa to klony substancji, nie sa to substancje wprost z listy wzorcow w MenedzerzeZielarstwa)
        public PrzedmiotLeczniczy()
        {
            AktywneSubstancje = new List<Substancja>();
        }
        //skopiuj z innego przedmiotu-wzorca
        public PrzedmiotLeczniczy(PrzedmiotLeczniczy wzorzec)
        {
            AktywneSubstancje = new List<Substancja>();
            Nazwa = wzorzec.Nazwa;
            CzasDzialania = wzorzec.CzasDzialania;
            PozostalyCzasDzialania = wzorzec.PozostalyCzasDzialania;
            foreach (Substancja wzorzecSubstancja in wzorzec.AktywneSubstancje)
                AktywneSubstancje.Add(new Substancja(wzorzecSubstancja));
        }
        //zaladuj dane przedmiotu z pojedynczego wezla XML 
        public void ZaladujDane(XElement elementXMLDanych, List<Substancja> listaWzorcowSubstancji)
        {
            if (elementXMLDanych.Attribute("nazwa") == null)
                Debug.LogError("Brak atrybutu nazwa w elemencie danych " + elementXMLDanych.ToString());
            else
                Nazwa = elementXMLDanych.Attribute("nazwa").Value;
            if (elementXMLDanych.Attribute("czas") != null)
                CzasDzialania = int.Parse(elementXMLDanych.Attribute("czas").Value);
            else
                CzasDzialania = 1;
           
            PozostalyCzasDzialania = CzasDzialania;
            foreach (XElement podElement in elementXMLDanych.Elements())
            {
                if (podElement.Name == "substancja")
                {
                    if(podElement.Attribute("nazwa") == null)
                        Debug.LogError("Brak atrybutu nazwa w elemencie danych " + podElement.ToString());
                    else
                    {
                        string nazwaSubstancji = podElement.Attribute("nazwa").Value;
                        Substancja ZnalezionaSubstancja = null;
                        foreach(Substancja subst in listaWzorcowSubstancji)
                        {
                            if (subst.Nazwa == nazwaSubstancji)
                                ZnalezionaSubstancja = new Substancja(subst);
                        }
                        if(ZnalezionaSubstancja == null)
                            Debug.LogError("Nie można znaleźć substancji o nazwie " + nazwaSubstancji);
                        else
                        {
                            if (podElement.Attribute("ilosc") == null)
                                ZnalezionaSubstancja.Wielkosc = 1;
                            else
                                ZnalezionaSubstancja.Wielkosc = int.Parse(podElement.Attribute("ilosc").Value );
                            AktywneSubstancje.Add(ZnalezionaSubstancja);
                        }
                    }
                }
            }
        }
        public void ZuzyjDawke()
        {
            PozostalyCzasDzialania--;
        }
        public float PodajGodzinoweLeczenie(ZdarzenieMedyczne zdarzenie)
        {
           foreach (Substancja subst in AktywneSubstancje)
           {
                foreach (LeczenieZdarzenia leczenie in subst.Leczenie)
                    if (leczenie.WartoscGraniczna <= subst.Wielkosc && leczenie.TypZdarzenia == zdarzenie.Nazwa && (leczenie.GdzieLeczy & zdarzenie.Lokalizacja) != 0 && PozostalyCzasDzialania > 0)
                        return leczenie.Leczenie / CzasDzialania;
            }
            return 0;
        }
	public void ResetujCzasDzialania()
        {
            PozostalyCzasDzialania = CzasDzialania;
        }
    }


}
