﻿// **** Autor: Jacek Ross - games@ejr.com.pl
// **** Plik jest czescia projektu SymulatorZielarza stworzonego na potrzeby ksiazki "Unity i C#. Praktyka programowania gier" wyd. Helion 2020 oraz czescia kodu gry SymulatorZielarza wydanej w serwisie Steam, wiecej info: http://ejr.com.pl
// **** Dozwolone użycie pod licencją CC0 1.0 (public domain). 
// **** Jeżeli modyfikujesz niniejszy plik - umiesc w nim informacje o tym, ze zawartosc odbiega od oryginalu albo usun informacje o autorze

// **** Author: Jacek Ross - games@ejr.com.pl
// **** This file is a part of SymulatorZielarza project created for book "Unity i C#. Praktyka programowania gier" published by Helion 2020 and a part of source of game SymulatorZielarza published on Steam, more info: http://ejr.com.pl
// **** Usage permission under CC0 1.0 license (public domain). 
// **** If you modified this file - put here an information about that the content of file is modified and diffrent than the original, or delete info about original author

using System;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.UI;

namespace ZielarzSilnik
{
    public class UIHandlu : MonoBehaviour
    {
        public Text TekstInformacyjnyKupca, TekstInformacyjnyGracza;
        public Text TekstZlotoKupca, TekstZlotoGracza;
        public Text TekstSprzedamKupca, TekstSprzedamGracza;       
        public Image[] PolaPrzedmiotowKupca;
        public Image[] PolaPrzedmiotowGracza;
        public Text PrzyciskDokonajKupna, PrzyciskDokonajSprzedazy;
        public Canvas KanwaHandlu;

        private const float CZESTOTLIWOSCSPRAWDZANODLEGLOSCI = 0.5f;
        private List<GameObject> _przedmiotyGracza;
        private List<GameObject> _przedmiotyKupca;
        private float _licznikSekund;
        private Przedmiot _wybranyPrzedmiotKupca, _wybranyPrzedmiotGracza;
        private Handlarz _wewnetrznyHandlarz;

        //akcja po kliknięciu w przycisk z nazwą przedmiotu kupca - zmienia pola informacyjne na Sprzedam
        public void KlikniecieWPrzedmiotKupca(int ktoryPrzycisk)
        {
            _wybranyPrzedmiotKupca = _przedmiotyKupca[ktoryPrzycisk].GetComponent<Przedmiot>();
            TekstSprzedamKupca.text = string.Format(TlumaczCiagow.PodajCiag("Sprzedam"), _wybranyPrzedmiotKupca.CzytelnaNazwa, _wybranyPrzedmiotKupca.WewnetrzneDane.Wartosc);
            TekstSprzedamKupca.gameObject.SetActive(true);           
            _wybranyPrzedmiotGracza = null;
            TekstSprzedamGracza.gameObject.SetActive(false);
            PrzyciskDokonajKupna.gameObject.SetActive(CzyGraczMozeKupic(_wybranyPrzedmiotKupca));
            PrzyciskDokonajSprzedazy.gameObject.SetActive(false);
        }
        //akcja po kliknięciu w przycisk z nazwą przedmiotu gracza - zmienia pola informacyjne na Sprzedam
        public void KlikniecieWPrzedmiotGracza(int ktoryPrzycisk)
        {
            _wybranyPrzedmiotGracza = _przedmiotyGracza[ktoryPrzycisk].GetComponent<Przedmiot>();
            TekstSprzedamGracza.text = string.Format(TlumaczCiagow.PodajCiag("Kupie"), _wybranyPrzedmiotGracza.CzytelnaNazwa, _wewnetrznyHandlarz.ZaIleKupie(_wybranyPrzedmiotGracza));
            TekstSprzedamGracza.gameObject.SetActive(true);
            _wybranyPrzedmiotKupca = null;
            TekstSprzedamKupca.gameObject.SetActive(false);
            PrzyciskDokonajKupna.gameObject.SetActive(false);
            PrzyciskDokonajSprzedazy.gameObject.SetActive(CzyKupiecMozeKupic(_wybranyPrzedmiotGracza));
        }
        //akcja po kliknięciu przycisku akceptacji zakupu przez gracza
        public void KlikniecieDoknajKupna ()
        {
            if(_wybranyPrzedmiotKupca != null && CzyGraczMozeKupic(_wybranyPrzedmiotKupca))
            {
                _wewnetrznyHandlarz.UstawAtrybut("Zloto", _wewnetrznyHandlarz.PobierzAtrybut("Zloto") + _wybranyPrzedmiotKupca.WewnetrzneDane.Wartosc);
                MenedzerGry.InstancjaMenedzeraGry.ObiektGracza.UstawAtrybut("Zloto", MenedzerGry.InstancjaMenedzeraGry.ObiektGracza.PobierzAtrybut("Zloto") - _wybranyPrzedmiotKupca.WewnetrzneDane.Wartosc);
                if (_wybranyPrzedmiotKupca.WewnetrznaReceptura != null)
                    MenedzerGry.InstancjaMenedzeraGry.ObiektGracza.PoznajRecepture(_wybranyPrzedmiotKupca);
                else
                {
                    _wybranyPrzedmiotKupca.PrzygotujNaPlecak();
                    MenedzerGry.InstancjaMenedzeraGry.ObiektPlecaka.Dodaj(_wybranyPrzedmiotKupca);
                }
                _wewnetrznyHandlarz.UsunPrzedmiot(_wybranyPrzedmiotKupca.Nazwa);
                _przedmiotyKupca.Remove(_wybranyPrzedmiotKupca.gameObject);
                MenedzerUI.Instancja.PokazMaleInfo(TlumaczCiagow.PodajCiag("Zakupiles") + _wybranyPrzedmiotKupca.CzytelnaNazwa);
            }
            OdswiezInformacje();
            _wewnetrznyHandlarz.ZapiszGre();
        }
        //akcja po kliknięciu przycisku akceptacji sprzedazy przez gracza
        public void KlikniecieDoknajSprzedazy()
        {
            if (_wybranyPrzedmiotGracza != null && CzyKupiecMozeKupic(_wybranyPrzedmiotGracza))
            {
                _wewnetrznyHandlarz.UstawAtrybut("Zloto", _wewnetrznyHandlarz.PobierzAtrybut("Zloto") -_wewnetrznyHandlarz.ZaIleKupie(_wybranyPrzedmiotGracza));
                MenedzerGry.InstancjaMenedzeraGry.ObiektGracza.UstawAtrybut("Zloto", MenedzerGry.InstancjaMenedzeraGry.ObiektGracza.PobierzAtrybut("Zloto") + _wewnetrznyHandlarz.ZaIleKupie(_wybranyPrzedmiotGracza));
                MenedzerGry.InstancjaMenedzeraGry.ObiektPlecaka.ZniszczPoCichuPrzedmiot(MenedzerGry.InstancjaMenedzeraGry.ObiektPlecaka.ZnajdzPrzedmiot(_wybranyPrzedmiotGracza.Nazwa));
                _wewnetrznyHandlarz.DodajLubZamienPrzedmiot(_wybranyPrzedmiotGracza.Nazwa);
                MenedzerUI.Instancja.PokazMaleInfo(TlumaczCiagow.PodajCiag("Sprzedales")+ _wybranyPrzedmiotGracza.CzytelnaNazwa);
            }
            OdswiezInformacje();
            _wewnetrznyHandlarz.ZapiszGre();
        }       
        private void Awake()
        {
            KanwaHandlu.gameObject.SetActive(false);
        }
        private void Start()
        {
            if (PolaPrzedmiotowKupca.Length == 0)
                Debug.LogError("Nie ustawiono pola PolaPrzedmiotowKupca");
            if (PolaPrzedmiotowGracza.Length == 0)
                Debug.LogError("Nie ustawiono pola PolaPrzedmiotowGracza");
            if (TekstInformacyjnyKupca == null)
                Debug.LogError("Nie ustawiono pola TekstInformacyjnyKupca");
            if (TekstInformacyjnyGracza == null)
                Debug.LogError("Nie ustawiono pola TekstInformacyjnyGracza");
            if (TekstZlotoKupca == null)
                Debug.LogError("Nie ustawiono pola TekstZlotoKupca");
            if (TekstZlotoGracza == null)
                Debug.LogError("Nie ustawiono pola TekstZlotoGracza");
            if (TekstSprzedamKupca == null)
                Debug.LogError("Nie ustawiono pola TekstSprzedamKupca");
            if (TekstSprzedamGracza == null)
                Debug.LogError("Nie ustawiono pola TekstSprzedamGracza");
            if (PrzyciskDokonajKupna == null)
                Debug.LogError("Nie ustawiono pola PrzyciskDokonajKupna");
            if (PrzyciskDokonajSprzedazy == null)
                Debug.LogError("Nie ustawiono pola PrzyciskDokonajSprzedazy");
            if (KanwaHandlu == null)
                Debug.LogError("Nie ustawiono pola KanwaHandlu");
            TekstInformacyjnyKupca.text = TlumaczCiagow.PodajCiag("Handlarz1");
            TekstInformacyjnyGracza.text = TlumaczCiagow.PodajCiag("Handlarz2");
            PrzyciskDokonajSprzedazy.text = TlumaczCiagow.PodajCiag("Sprzedaje");
            PrzyciskDokonajKupna.text = TlumaczCiagow.PodajCiag("Kupuje");
            _licznikSekund = 0;
            _przedmiotyGracza = null;
            _wewnetrznyHandlarz = new Handlarz();
        }
        public void Uaktywnij()
        {
            _wybranyPrzedmiotKupca = null;
            _wybranyPrzedmiotGracza = null;
            KanwaHandlu.gameObject.SetActive(true);
            _wewnetrznyHandlarz.OdswiezanieSklepu = false;
            OdswiezInformacje();
        }
        public void Zapisz()
        {
            _wewnetrznyHandlarz.ZapiszGre();
        }
        void Update()
        {
            if (KanwaHandlu.gameObject.activeInHierarchy)
            {
                TekstZlotoGracza.text = string.Format(TlumaczCiagow.PodajCiag("Posiadasz"), MenedzerGry.InstancjaMenedzeraGry.ObiektGracza.PobierzAtrybut("Zloto"));
                TekstZlotoKupca.text = string.Format(TlumaczCiagow.PodajCiag("Posiadam"), _wewnetrznyHandlarz.PobierzAtrybut("Zloto"));
                _licznikSekund -= Time.deltaTime;
                if (_licznikSekund < 0)
                {
                    _licznikSekund = CZESTOTLIWOSCSPRAWDZANODLEGLOSCI;
                    if ((MenedzerGry.InstancjaMenedzeraGry.KontrolerGracza.transform.position - transform.position).magnitude > MenedzerUI.DYSTANSPOKAZYWANIAKANWY)
                    {
                        ZwolnijListyPrzedmiotow();
                        KanwaHandlu.gameObject.SetActive(false);
                        _wewnetrznyHandlarz.OdswiezanieSklepu = true;
                    }                    
                }
            }
        }

        private void OdswiezInformacje()
        {
            ZwolnijListyPrzedmiotow();
            _przedmiotyGracza = ZbudujListePrzedmiotowGracza();
            _przedmiotyKupca = ZbudujListePrzedmiotowKupca();
            int indeksPola = 0;
            for(int i = 0; i < _przedmiotyGracza.Count; i++)
            {
                PolaPrzedmiotowGracza[indeksPola].gameObject.SetActive(true);
                PolaPrzedmiotowGracza[indeksPola].transform.GetComponentInChildren<Text>().text = _przedmiotyGracza[i].GetComponent<Przedmiot>().CzytelnaNazwa;
                _przedmiotyGracza[i].transform.parent = PolaPrzedmiotowGracza[indeksPola].transform;
                _przedmiotyGracza[i].transform.localPosition = Vector3.zero + _przedmiotyGracza[i].GetComponent<Przedmiot>().PrzesuniecieWPlecaku;
                _przedmiotyGracza[i].transform.localRotation = Quaternion.Euler(_przedmiotyGracza[i].GetComponent<Przedmiot>().RotacjaWPlecaku);
                _przedmiotyGracza[i].transform.localScale = new Vector3(0.9f, 0.9f, 0.9f);
                indeksPola++;
            }
            for (; indeksPola < PolaPrzedmiotowGracza.Length; indeksPola++)
                PolaPrzedmiotowGracza[indeksPola].gameObject.SetActive(false);
            indeksPola = 0;
            for (int i = 0; i < _przedmiotyKupca.Count; i++)
            {
                PolaPrzedmiotowKupca[indeksPola].gameObject.SetActive(true);
                PolaPrzedmiotowKupca[indeksPola].transform.GetComponentInChildren<Text>().text = _przedmiotyKupca[i].GetComponent<Przedmiot>().CzytelnaNazwa;
                _przedmiotyKupca[i].transform.parent = PolaPrzedmiotowKupca[indeksPola].transform;
                _przedmiotyKupca[i].transform.localPosition = Vector3.zero + _przedmiotyKupca[i].GetComponent<Przedmiot>().PrzesuniecieWPlecaku;
                _przedmiotyKupca[i].transform.localRotation = Quaternion.Euler(_przedmiotyKupca[i].GetComponent<Przedmiot>().RotacjaWPlecaku);
                _przedmiotyKupca[i].transform.localScale = new Vector3(0.9f, 0.9f, 0.9f);
                indeksPola++;
            }
            for (; indeksPola < PolaPrzedmiotowKupca.Length; indeksPola++)
                PolaPrzedmiotowKupca[indeksPola].gameObject.SetActive(false);
            _wybranyPrzedmiotGracza = null;
            _wybranyPrzedmiotKupca = null;
            TekstSprzedamGracza.gameObject.SetActive(false);
            TekstSprzedamKupca.gameObject.SetActive(false);
            PrzyciskDokonajKupna.gameObject.SetActive(false);
            PrzyciskDokonajSprzedazy.gameObject.SetActive(false);
        }

        //tworzy i zwraca liste przedmiotow gracza na sprzedaz
        private List<GameObject> ZbudujListePrzedmiotowGracza()
        {
            List<GameObject> zwracanaLista = new List<GameObject>();
            for (int i = 0; i < Plecak.ROZMIARPLECAKA; i++)
                if (MenedzerGry.InstancjaMenedzeraGry.ObiektPlecaka[i] != null)
                {
                    Przedmiot nowyPrzedmiot = PulaAktywnychPrzedmiotow.Instancja.PodajObiekt(MenedzerGry.InstancjaMenedzeraGry.ObiektPlecaka[i].Nazwa).GetComponent<Przedmiot>();
                    nowyPrzedmiot.PrzygotujNaPlecak();
                    zwracanaLista.Add(nowyPrzedmiot.gameObject);
                }
            return zwracanaLista;
        }
        //tworzy i zwraca liste przedmiotow kupca na sprzedaz
        private List<GameObject> ZbudujListePrzedmiotowKupca()
        {
            List<GameObject> zwracanaLista = new List<GameObject>();
            for (int i = 0; i < Handlarz.MAKSIMUMPRZEDMIOTOW; i++)
                if (_wewnetrznyHandlarz.PodajKolejnyPrzedmiot(i) != null)
                {
                    Przedmiot nowyPrzedmiot = PulaAktywnychPrzedmiotow.Instancja.PodajObiekt(_wewnetrznyHandlarz.PodajKolejnyPrzedmiot(i)).GetComponent<Przedmiot>();
                    nowyPrzedmiot.PrzygotujNaPlecak();
                    zwracanaLista.Add(nowyPrzedmiot.gameObject);
                }
            return zwracanaLista;
        }

        //zwalnia wczesniej pobrane z puli przedmioty 
        private void ZwolnijListePrzedmiotowWewnetrznie(List<GameObject> lista)
        {
            if (lista != null)
                for (int i = 0; i < lista.Count; i++)
                {
                    lista[i].GetComponent<Przedmiot>().UsunZPlecaka();
                    PulaAktywnychPrzedmiotow.Instancja.ZwolnijObiekt(lista[i]);
                }
        }
        //zwalnia wczesniej pobrane z puli przedmioty 
        private void ZwolnijListyPrzedmiotow()
        {
            ZwolnijListePrzedmiotowWewnetrznie(_przedmiotyGracza);
            _przedmiotyGracza = null;
            ZwolnijListePrzedmiotowWewnetrznie(_przedmiotyKupca);
            _przedmiotyKupca = null;
        }

        //sprawdza czy kupiec może kupić przedmiot o nazwie przedmiot
        private bool CzyKupiecMozeKupic(Przedmiot przedmiot)
        {
            if (_wewnetrznyHandlarz.PobierzAtrybut("Zloto") < _wewnetrznyHandlarz.ZaIleKupie(przedmiot))
                return false;
            return true;
        }
        //sprawdza czy gracz może kupić przedmiot o nazwie przedmiot
        private bool CzyGraczMozeKupic(Przedmiot przedmiot)
        {
            if (MenedzerGry.InstancjaMenedzeraGry.ObiektGracza.PobierzAtrybut("Zloto") < przedmiot.WewnetrzneDane.Wartosc)
                return false;
            if(!MenedzerGry.InstancjaMenedzeraGry.ObiektPlecaka.CzyMoznaDodacPrzedmiot(przedmiot))
                return false;
            return true;
        }
    }
}
