﻿// **** Autor: Jacek Ross - games@ejr.com.pl
// **** Plik jest czescia projektu SymulatorZielarza stworzonego na potrzeby ksiazki "Unity i C#. Praktyka programowania gier" wyd. Helion 2020 oraz czescia kodu gry SymulatorZielarza wydanej w serwisie Steam, wiecej info: http://ejr.com.pl
// **** Dozwolone użycie pod licencją CC0 1.0 (public domain). 
// **** Jeżeli modyfikujesz niniejszy plik - umiesc w nim informacje o tym, ze zawartosc odbiega od oryginalu albo usun informacje o autorze

// **** Author: Jacek Ross - games@ejr.com.pl
// **** This file is a part of SymulatorZielarza project created for book "Unity i C#. Praktyka programowania gier" published by Helion 2020 and a part of source of game SymulatorZielarza published on Steam, more info: http://ejr.com.pl
// **** Usage permission under CC0 1.0 license (public domain). 
// **** If you modified this file - put here an information about that the content of file is modified and diffrent than the original, or delete info about original author

using System;
using System.Collections.Generic;
using System.Text;
using UnityEngine;
using ZielarzSilnik.StanGry;

namespace ZielarzSilnik
{

    public class MenedzerGry: MonoBehaviour
    {
        public const bool WERSJADEBUG = false;
        public static MenedzerGry InstancjaMenedzeraGry { get; private set; }
        public Gracz ObiektGracza { get; private set; }
        public GameObject[] PunktyPacjentowStacjonarnych,  PunktyPacjentowLezacych;
        public GameObject KontrolerGracza;
        public Plecak ObiektPlecaka;

        private bool _PierwszyUpdate;
        private GameObject _SzablonPacjentaStojacego, _SzablonPacjentaLezacego;
        private IStanGry _menedzerZapisu;
        public void ZapiszGre()
        {
            _menedzerZapisu.ZapiszKlucz("pozycja_gracza_x", KontrolerGracza.transform.position.x);
            _menedzerZapisu.ZapiszKlucz("pozycja_gracza_y", KontrolerGracza.transform.position.y);
            _menedzerZapisu.ZapiszKlucz("pozycja_gracza_z", KontrolerGracza.transform.position.z);
        
            ObiektGracza.ZapiszGre();
            ObiektPlecaka.ZapiszGre();
            MenedzerAktywnychPrzedmiotow.Instancja.ZapiszGre();
            _menedzerZapisu.ZapiszGre();
  
        }
        public void OdczytajGre()
        {
            _menedzerZapisu.ZaladujGre();
            MenedzerAktywnychPrzedmiotow.Instancja.OdczytajGre();
            ObiektPlecaka.OdczytajGre();
            ObiektGracza.OdczytajGre();
  	    if (_menedzerZapisu.istniejeKlucz("pozycja_gracza_x"))
               KontrolerGracza.GetComponent<KontrolerGracza>().PrzesunGracza(new Vector3(
                 _menedzerZapisu.PobierzKluczFloat("pozycja_gracza_x"), _menedzerZapisu.PobierzKluczFloat("pozycja_gracza_y"), _menedzerZapisu.PobierzKluczFloat("pozycja_gracza_z")));
          
        }
        public void ZapiszZmienna(string zmienna, object wartosc)
        {
            _menedzerZapisu.ZapiszKlucz(zmienna, wartosc);
        }
        public int OdczytajZmiennaInt(string zmienna)
        {
            return _menedzerZapisu.PobierzKluczInt(zmienna);
        }
        public float OdczytajZmiennaFloat(string zmienna)
        {
            return _menedzerZapisu.PobierzKluczFloat(zmienna);
        }
        public string OdczytajZmiennaString(string zmienna)
        {
            return _menedzerZapisu.PobierzKluczString(zmienna);
        }
        public string WykonajMasowyTestChorob(int liczba)
        {
            StringBuilder wynik = new StringBuilder();
            Dictionary<string, int> przyczynyZgonow = new Dictionary<string, int>();

            int wyleczono = 0;
            int zmarlBezPrzyczyny = 0;
            for (int i = 0; i < liczba; i++)
            {
                Pacjent pacjent = new Pacjent();
                pacjent.WylosujChoroby(UnityEngine.Random.Range(0, 2) == 0);
                while (!pacjent.JestZdrowy && pacjent.JestZywy)
                {
                    pacjent.GodzinowaObslugaZdarzen();
                }
                if (pacjent.JestZdrowy)
                    wyleczono++;
                else if (pacjent.PrzyczynaZgonu == "")
                    zmarlBezPrzyczyny++;
                else
                {
                    if (przyczynyZgonow.ContainsKey(pacjent.PrzyczynaZgonu))
                        przyczynyZgonow[pacjent.PrzyczynaZgonu]++;
                    else
                        przyczynyZgonow.Add(pacjent.PrzyczynaZgonu, 1);
                }
            }
            foreach(string przyczyna in przyczynyZgonow.Keys)
                wynik.Append("Zmarło z powodu " + przyczyna +": " + (100 * przyczynyZgonow[przyczyna] / liczba).ToString() + "% pacjentów. \n\r");
            wynik.Append("Zmarło z wycieńczenia: " + (100 * zmarlBezPrzyczyny / liczba).ToString() + "% pacjentów.\n\r");
            wynik.Append("Wyleczono: " + (100 * wyleczono / liczba).ToString() + "% pacjentów.\n\r");
            return wynik.ToString();
        }

        private void Awake()
        {
            if (InstancjaMenedzeraGry != null && InstancjaMenedzeraGry != this)
                throw new Exception("Niedozwolone tworzenie kolejnej kopii klasy MenedzerGry");
            InstancjaMenedzeraGry = this;
            _PierwszyUpdate = true;
            _SzablonPacjentaLezacego = null;
            _SzablonPacjentaStojacego = null;
            _menedzerZapisu = FabrykaMenedzeraStanuGry.InstancjaMenedzera();
            MenedzerZielarstwa.Instancja.ZaladujDane();
            ObiektGracza = new Gracz();
            
        }
        private void Start()
        {
            OdczytajGre();
        }

        private void Update()
        {
            if (_PierwszyUpdate)
            {
                ObiektGracza.Inicjuj();
                SystemDniaNocyPogody.Instancja.ZmianaGodziny += UplynelaGodzina;
                _PierwszyUpdate = false;
            }
        }
        private void OnApplicationQuit()
        {
            ZapiszGre();
        }

        private void UplynelaGodzina(int godzina)
        {
            float reputacja = MenedzerGry.InstancjaMenedzeraGry.ObiektGracza.PobierzAtrybut("Reputacja");
            int rorzutLosowosci = 1;
            if (reputacja < 0.25)
                rorzutLosowosci = 8;
            else if (reputacja < 0.5)
                rorzutLosowosci = 6;
            else if (reputacja < 0.75)
                rorzutLosowosci = 4;
            else if (reputacja < 1)
                rorzutLosowosci = 3;
            else if (reputacja < 1.33)
                rorzutLosowosci = 2;
            foreach (GameObject punktpacjenta in PunktyPacjentowStacjonarnych)
                if (punktpacjenta.transform.childCount == 0 && UnityEngine.Random.Range(0, rorzutLosowosci) == 0)
                    UtworzPacjenta(punktpacjenta, false);
            foreach (GameObject punktpacjenta in PunktyPacjentowLezacych)
                if (punktpacjenta.transform.childCount == 0 && UnityEngine.Random.Range(0, rorzutLosowosci) == 0)
                    UtworzPacjenta(punktpacjenta, true);           
        }

        private void UtworzPacjenta(GameObject punktTworzenia, bool lezacy)
        {
            if (_SzablonPacjentaStojacego == null)
                _SzablonPacjentaStojacego = Resources.Load<GameObject>("Prefaby/Pacjent");
            if (_SzablonPacjentaLezacego == null)
                _SzablonPacjentaLezacego = Resources.Load<GameObject>("Prefaby/PacjentLezacy");
            if (_SzablonPacjentaStojacego == null || _SzablonPacjentaLezacego == null)
                Debug.LogError("Nie udało się załadować szablonu pacjenta z zasobów.");
            else
            {
                GameObject nowyPacjent = Instantiate(lezacy ?  _SzablonPacjentaLezacego : _SzablonPacjentaStojacego, punktTworzenia.transform);
                nowyPacjent.transform.localPosition = Vector3.zero;
                nowyPacjent.transform.localRotation = Quaternion.identity;
                nowyPacjent.GetComponent<KomponentPacjent>().WylosujChoroby(lezacy);
                MenedzerUI.Instancja.PokazMaleInfo(TlumaczCiagow.PodajCiag(lezacy ? "NowyPacjentLezy" : "NowyPacjentStoi") + nowyPacjent.GetComponent<KomponentPacjent>().WewnetrznyPacjent.IDPacjenta);
            }
        }
    }


}
