﻿// **** Autor: Jacek Ross - games@ejr.com.pl
// **** Plik jest czescia projektu SymulatorZielarza stworzonego na potrzeby ksiazki "Unity i C#. Praktyka programowania gier" wyd. Helion 2020 oraz czescia kodu gry SymulatorZielarza wydanej w serwisie Steam, wiecej info: http://ejr.com.pl
// **** Dozwolone użycie pod licencją CC0 1.0 (public domain). 
// **** Jeżeli modyfikujesz niniejszy plik - umiesc w nim informacje o tym, ze zawartosc odbiega od oryginalu albo usun informacje o autorze

// **** Author: Jacek Ross - games@ejr.com.pl
// **** This file is a part of SymulatorZielarza project created for book "Unity i C#. Praktyka programowania gier" published by Helion 2020 and a part of source of game SymulatorZielarza published on Steam, more info: http://ejr.com.pl
// **** Usage permission under CC0 1.0 license (public domain). 
// **** If you modified this file - put here an information about that the content of file is modified and diffrent than the original, or delete info about original author

using System.Collections.Generic;
using UnityEngine;
using UnityEngine.UI;

namespace ZielarzSilnik
{

    public class KomponentPacjent : MonoBehaviour
    {
        private const float DYSTANSPOKAZYWANIAKANWY = 5;
        private const float CZESTOTLIWOSCSPRAWDZANODLEGLOSCI = 0.5f;

        public Pacjent WewnetrznyPacjent { get; private set; }

        private Text _infoPacjenta;
        private float _licznikSekund;

        private void Awake()
        {
            WewnetrznyPacjent = new Pacjent();
            Canvas UIPacjenta = GetComponentInChildren<Canvas>();
            if (UIPacjenta != null)
                _infoPacjenta = UIPacjenta.GetComponentInChildren<Text>();
            SystemDniaNocyPogody.Instancja.ZmianaGodziny += UplynelaGodzina;

            _licznikSekund = 0;
        }
        void Update()
        {
            Vector3 lookTarget = new Vector3(MenedzerGry.InstancjaMenedzeraGry.KontrolerGracza.transform.position.x, transform.position.y, MenedzerGry.InstancjaMenedzeraGry.KontrolerGracza.transform.position.z);
            Quaternion lookDirection = Quaternion.LookRotation(lookTarget - transform.position, transform.up);
            transform.rotation = lookDirection;
            _licznikSekund -= Time.deltaTime;
            if (_licznikSekund < 0)
            {
                _licznikSekund = CZESTOTLIWOSCSPRAWDZANODLEGLOSCI;
                if ((MenedzerGry.InstancjaMenedzeraGry.KontrolerGracza.transform.position - transform.position).magnitude < DYSTANSPOKAZYWANIAKANWY)
                    _infoPacjenta.transform.parent.gameObject.SetActive(true);
                else
                    _infoPacjenta.transform.parent.gameObject.SetActive(false);

            }
        }

        public void WylosujChoroby()
        {
            WewnetrznyPacjent.WylosujChoroby();
            gameObject.SetActive(WewnetrznyPacjent.LiczbaAktualnychZdarzen > 0);
            if (_infoPacjenta != null)
                _infoPacjenta.text = WewnetrznyPacjent.ZrzutDebugZdarzen();
        }
        //przekazuje pacjentowi przedmiot, zwraca true jeśli przedmiot został przyjęty lub false jeśli nie
        public bool DodajPrzedmiotLeczacy(Przedmiot nowyPrzedmiot)
        {
            if (nowyPrzedmiot == null || nowyPrzedmiot.WewnetrznyPrzedmiotLeczniczy == null)
                return false;
            WewnetrznyPacjent.DodajPrzedmiotLeczacy(new PrzedmiotLeczniczy(nowyPrzedmiot.WewnetrznyPrzedmiotLeczniczy));
            if (_infoPacjenta != null)
                _infoPacjenta.text = WewnetrznyPacjent.ZrzutDebugZdarzen();
            return true;
        }
        private void UplynelaGodzina(int godzina)
        {
            if (WewnetrznyPacjent.JestZywy)
            {
                WewnetrznyPacjent.GodzinowaObslugaZdarzen();
                if (_infoPacjenta != null)
                    _infoPacjenta.text = WewnetrznyPacjent.ZrzutDebugZdarzen();

                if (!WewnetrznyPacjent.JestZywy)
                {
                    if(WewnetrznyPacjent.PrzyczynaZgonu != "")
                        Debug.Log(string.Format("{0} {1} {2} {3}", TlumaczCiagow.PodajCiag("Pacjent"), WewnetrznyPacjent.IDPacjenta, TlumaczCiagow.PodajCiag("ZmarlGwaltownie"), WewnetrznyPacjent.PrzyczynaZgonu));
                    else
                        Debug.Log(string.Format("{0} {1} {2}", TlumaczCiagow.PodajCiag("Pacjent"), WewnetrznyPacjent.IDPacjenta,  TlumaczCiagow.PodajCiag("Zmarl")));
                }
                if (WewnetrznyPacjent.JestZdrowy)
                    Debug.Log(string.Format("{0} {1} {2}", TlumaczCiagow.PodajCiag("Pacjent"), WewnetrznyPacjent.IDPacjenta, TlumaczCiagow.PodajCiag("Wyzdrowial")));

                if (WewnetrznyPacjent.JestZdrowy || !WewnetrznyPacjent.JestZywy)
                {
                    SystemDniaNocyPogody.Instancja.ZmianaGodziny -= UplynelaGodzina;
                    Destroy(gameObject);
                }
            }
        }
             
       

    }
}
