﻿// **** Autor: Jacek Ross - games@ejr.com.pl
// **** Plik jest czescia projektu SymulatorZielarza stworzonego na potrzeby ksiazki "Unity i C#. Praktyka programowania gier" wyd. Helion 2020 oraz czescia kodu gry SymulatorZielarza wydanej w serwisie Steam, wiecej info: http://ejr.com.pl
// **** Dozwolone użycie pod licencją CC0 1.0 (public domain). 
// **** Jeżeli modyfikujesz niniejszy plik - umiesc w nim informacje o tym, ze zawartosc odbiega od oryginalu albo usun informacje o autorze

// **** Author: Jacek Ross - games@ejr.com.pl
// **** This file is a part of SymulatorZielarza project created for book "Unity i C#. Praktyka programowania gier" published by Helion 2020 and a part of source of game SymulatorZielarza published on Steam, more info: http://ejr.com.pl
// **** Usage permission under CC0 1.0 license (public domain). 
// **** If you modified this file - put here an information about that the content of file is modified and diffrent than the original, or delete info about original author


using UnityEngine;

namespace ZielarzSilnik
{    

    public class ZdarzenieMedyczne: WzorzecZdarzeniaMedycznego
    {
        public CzescCiala Lokalizacja;          // informacja gdzie zdarzenie wystapilo
        public float Sila;                      // intensywnosc zdarzenia ( aktualna)
        public float Zaostrzenie;               // przewlekosc/ostrosc zdarzenia czyli tempo narastania, jest to ulamek bedacy srednim przyrostem sily na dobe

        public ZdarzenieMedyczne(WzorzecZdarzeniaMedycznego wzorzec)
        {
            Nazwa = wzorzec.Nazwa;
            foreach (WplywNaParametr szkodliwosc in wzorzec.SzkodliwoscOgolna)
                SzkodliwoscOgolna.Add(new WplywNaParametr(szkodliwosc));
            Ujawnione = wzorzec.Ujawnione;
            Lokalizacja = CzescCiala.Dowolna;
            Smiertelnosc = wzorzec.Smiertelnosc;
            Sila = 1;
            Zaostrzenie = 0;
        }

        // cogodzinne przetworzenie wewnetrznego stanu zdarzenia
        public void PrzetworzGodzinowo()
        {
            Sila += Zaostrzenie / 24;
            Zaostrzenie += Random.Range(0, 0.1f) - 0.05f;
            Normalizuj();
        }
        //chcemy aby sila byla w zakresie 0..1 a Zaostrzenie -0.5..0.5
        public void Normalizuj()
        {
            if (Sila < 0)
                Sila = 0;
            if (Sila > 1)
                Sila = 1;
            if (Zaostrzenie < -0.5)
                Zaostrzenie = -0.5f;
            if (Zaostrzenie > 0.5)
                Zaostrzenie = 0.5f;
        }

        public string DajLadnaNazwe()
        {
            if (TlumaczCiagow.ZawieraCiag(Nazwa + Lokalizacja) )
                return TlumaczCiagow.PodajCiag(Nazwa + Lokalizacja) ;
            else if (TlumaczCiagow.ZawieraCiag(Nazwa) && TlumaczCiagow.ZawieraCiag(Lokalizacja + "dop"))
                return TlumaczCiagow.PodajCiag(Nazwa) + " " + TlumaczCiagow.PodajCiag(Lokalizacja + "dop");
            else
                return "<" + Nazwa + " " + Lokalizacja + ">";
        }
    }


}