﻿// **** Autor: Jacek Ross - games@ejr.com.pl
// **** Plik jest czescia projektu SymulatorZielarza stworzonego na potrzeby ksiazki "Unity i C#. Praktyka programowania gier" wyd. Helion 2020 oraz czescia kodu gry SymulatorZielarza wydanej w serwisie Steam, wiecej info: http://ejr.com.pl
// **** Dozwolone użycie pod licencją CC0 1.0 (public domain). 
// **** Jeżeli modyfikujesz niniejszy plik - umiesc w nim informacje o tym, ze zawartosc odbiega od oryginalu albo usun informacje o autorze

// **** Author: Jacek Ross - games@ejr.com.pl
// **** This file is a part of SymulatorZielarza project created for book "Unity i C#. Praktyka programowania gier" published by Helion 2020 and a part of source of game SymulatorZielarza published on Steam, more info: http://ejr.com.pl
// **** Usage permission under CC0 1.0 license (public domain). 
// **** If you modified this file - put here an information about that the content of file is modified and diffrent than the original, or delete info about original author

using UnityEngine;

namespace ZielarzSilnik
{

    public class KomponentPacjent : MonoBehaviour
    {
        public const int MAKSIMUM_CHOROB = 3;

        public Pacjent WewnetrznyPacjent { get; private set; }

        private void Start()
        {
            WewnetrznyPacjent = new Pacjent();
            SystemDniaNocyPogody.Instancja.ZmianaGodziny += UplynelaGodzina;
            SystemDniaNocyPogody.Instancja.ZmianaMinuty += UplynelaMinuta;
        }
        void Update()
        {
            Vector3 lookTarget = new Vector3(MenedzerGry.InstancjaMenedzeraGry.KontrolerGracza.transform.position.x, transform.position.y, MenedzerGry.InstancjaMenedzeraGry.KontrolerGracza.transform.position.z);
            Quaternion lookDirection = Quaternion.LookRotation(lookTarget - transform.position, transform.up);

            transform.rotation = lookDirection;
        }

        private void UplynelaGodzina(int godzina)
        {
            if (WewnetrznyPacjent.LiczbaAktualnychZdarzen < MAKSIMUM_CHOROB)
            {
                ZdarzenieMedyczne noweZdarzenie = MenedzerZielarstwa.Instancja.UtworzPierwotneZdarzenieMedyczne();
                if(noweZdarzenie != null)
                    WewnetrznyPacjent.DodajNoweZdarzenie(noweZdarzenie );
            }
                
            if(WewnetrznyPacjent.LiczbaAktualnychZdarzen > 0)
                gameObject.SetActive(true);
        }
        private void UplynelaMinuta(int minuta)
        {
            //chcemy aby pacjent zielarza mial jednak jakas chorobe wiec dopoki jej nie ma, to losujemy czesto oraz ukrywamy pacjenta
            if (WewnetrznyPacjent.LiczbaAktualnychZdarzen == 0)
            {
                ZdarzenieMedyczne zdarzenie = MenedzerZielarstwa.Instancja.UtworzPierwotneZdarzenieMedyczne();
                if (zdarzenie == null)
                    gameObject.SetActive(false);
                else
                {
                    WewnetrznyPacjent.DodajNoweZdarzenie(zdarzenie);
                    gameObject.SetActive(true);
                }

            }
        }
    }
}
