﻿// **** Autor: Jacek Ross - games@ejr.com.pl
// **** Plik jest czescia projektu SymulatorZielarza stworzonego na potrzeby ksiazki "Unity i C#. Praktyka programowania gier" wyd. Helion 2020 oraz czescia kodu gry SymulatorZielarza wydanej w serwisie Steam, wiecej info: http://ejr.com.pl
// **** Dozwolone użycie pod licencją CC0 1.0 (public domain). 
// **** Jeżeli modyfikujesz niniejszy plik - umiesc w nim informacje o tym, ze zawartosc odbiega od oryginalu albo usun informacje o autorze

// **** Author: Jacek Ross - games@ejr.com.pl
// **** This file is a part of SymulatorZielarza project created for book "Unity i C#. Praktyka programowania gier" published by Helion 2020 and a part of source of game SymulatorZielarza published on Steam, more info: http://ejr.com.pl
// **** Usage permission under CC0 1.0 license (public domain). 
// **** If you modified this file - put here an information about that the content of file is modified and diffrent than the original, or delete info about original author

using UnityEditor;
using UnityEngine;

public class KompilatorPakietowZasobow : MonoBehaviour
{
#if UNITY_EDITOR
    [MenuItem("Assets/Kompiluj Pakiet Zasobów")]
    static void KompilujPakietZasobow()
    {
        AssetDatabase.DeleteAsset("Assets/StreamingAssets/klientandroid");
        AssetDatabase.DeleteAsset("Assets/StreamingAssets/klientwindows");
#if UNITY_ANDROID

        AssetBundleBuild[] buildMap = new AssetBundleBuild[1];
        buildMap[0].assetBundleName = "klientAndroid";
        string[] assets = new string[2];
        assets[0] = "Assets/PRefabyKlientow/Android/KontrolerAndroid.prefab";
        assets[1] = "Assets/PRefabyKlientow/Android/KontrolerAndroidScenaStartowa.prefab";
        buildMap[0].assetNames = assets;
        BuildPipeline.BuildAssetBundles("Assets/AssetBundles", buildMap, BuildAssetBundleOptions.None, BuildTarget.Android);
        AssetDatabase.ImportAsset("Assets/AssetBundles/klientandroid");
        AssetDatabase.Refresh();
        AssetDatabase.CopyAsset("Assets/AssetBundles/klientandroid", "Assets/StreamingAssets/klientandroid");

#else
        AssetBundleBuild[] buildMap = new AssetBundleBuild[1];
        buildMap[0].assetBundleName = "klientWindows";
        string[] assets = new string[8];
        assets[0] = "Assets/PRefabyKlientow/WinPC/FPSController.prefab";
        assets[1] = "Assets/PRefabyKlientow/WinPC/FirstPersonCharacterStartScene.prefab";
        assets[2] = "Assets/PRefabyKlientow/WinVR/[CameraRig].prefab";
        assets[3] = "Assets/PRefabyKlientow/WinVR/[SteamVR].prefab";
        assets[4] = "Assets/PRefabyKlientow/WinVR/[CameraRig]StartScene.prefab";
        assets[5] = "Assets/PRefabyKlientow/Enviro Effects.prefab";
        assets[6] = "Assets/PRefabyKlientow/Enviro Directional Light.prefab";
        assets[7] = "Assets/PRefabyKlientow/Enviro Sky Manager.prefab";
        buildMap[0].assetNames = assets;
        BuildPipeline.BuildAssetBundles("Assets/AssetBundles", buildMap, BuildAssetBundleOptions.None, BuildTarget.StandaloneWindows64);
        AssetDatabase.ImportAsset("Assets/AssetBundles/klientWindows");
        AssetDatabase.Refresh();
        AssetDatabase.CopyAsset("Assets/AssetBundles/klientWindows", "Assets/StreamingAssets/klientWindows");

#endif
        Debug.Log("Kompilacja zakończona");
    }
#endif

}
