﻿// **** Autor: Jacek Ross - games@ejr.com.pl
// **** Plik jest czescia projektu SymulatorZielarza stworzonego na potrzeby ksiazki "Unity i C#. Praktyka programowania gier" wyd. Helion 2020 oraz czescia kodu gry SymulatorZielarza wydanej w serwisie Steam, wiecej info: http://ejr.com.pl
// **** Dozwolone użycie pod licencją CC0 1.0 (public domain). 
// **** Jeżeli modyfikujesz niniejszy plik - umiesc w nim informacje o tym, ze zawartosc odbiega od oryginalu albo usun informacje o autorze

// **** Author: Jacek Ross - games@ejr.com.pl
// **** This file is a part of SymulatorZielarza project created for book "Unity i C#. Praktyka programowania gier" published by Helion 2020 and a part of source of game SymulatorZielarza published on Steam, more info: http://ejr.com.pl
// **** Usage permission under CC0 1.0 license (public domain). 
// **** If you modified this file - put here an information about that the content of file is modified and diffrent than the original, or delete info about original author


using System.Linq;
using System.Text;
using System.IO;

namespace ZielarzSilnik.StanGry
{
    public class MenedzerStanuGryWindows : MenedzerStanuGry
    {
        public MenedzerStanuGryWindows() :base()
        {
           
        }

        protected override void UsunPlik(string nazwaPliku)
        {
            if (File.Exists(SciezkaZapisu() + "/" + nazwaPliku + ".dat"))
                File.Delete(SciezkaZapisu() + "/" + nazwaPliku + ".dat");
        }
        protected override string ZaladujPliki(string nazwaPliku)
        {
            if (!Directory.Exists(SciezkaZapisu()))
                Directory.CreateDirectory(SciezkaZapisu());
            string sciezka = SciezkaZapisu() + "/" + nazwaPliku + ".dat";
            if (File.Exists(sciezka))
            {
                StreamReader strumien = File.OpenText(sciezka);
                string zawartosc = strumien.ReadToEnd();
                strumien.Close();
                return zawartosc;
            }
            else return "";
        }

        protected override void ZapiszPliki(string nazwaPliku)
        {
            if (!Directory.Exists(SciezkaZapisu()))
                Directory.CreateDirectory(SciezkaZapisu());
            StringBuilder sb = new StringBuilder();
            foreach (string key in _zmienne.Keys)
                sb.Append(key + "=" + _zmienne[key] + '\n');
            string zawartosc = sb.ToString();
            StreamWriter strumien;
            strumien = File.CreateText(SciezkaZapisu() + "/" + nazwaPliku + ".dat");
            strumien.WriteLine(zawartosc);
            strumien.Close();
        }
    }
}
