﻿// **** Autor: Jacek Ross - games@ejr.com.pl
// **** Plik jest czescia projektu SymulatorZielarza stworzonego na potrzeby ksiazki "Unity i C#. Praktyka programowania gier" wyd. Helion 2020 oraz czescia kodu gry SymulatorZielarza wydanej w serwisie Steam, wiecej info: http://ejr.com.pl
// **** Dozwolone użycie pod licencją CC0 1.0 (public domain). 
// **** Jeżeli modyfikujesz niniejszy plik - umiesc w nim informacje o tym, ze zawartosc odbiega od oryginalu albo usun informacje o autorze

// **** Author: Jacek Ross - games@ejr.com.pl
// **** This file is a part of SymulatorZielarza project created for book "Unity i C#. Praktyka programowania gier" published by Helion 2020 and a part of source of game SymulatorZielarza published on Steam, more info: http://ejr.com.pl
// **** Usage permission under CC0 1.0 license (public domain). 
// **** If you modified this file - put here an information about that the content of file is modified and diffrent than the original, or delete info about original author

using System.Collections.Generic;
using System.Text;
using System.Xml.Linq;
using UnityEngine;

namespace ZielarzSilnik
{
    public sealed class MenedzerZielarstwa
    {
        private List<WzorzecZdarzeniaMedycznego> _wzorceZdarzen;  //lista zdarzen med. zaladowane z konfiguracji
        private List<Substancja> _wzorceSubstancji;              // dostepne w grze listy substancji medycznych zaladowane z konfiguracji
        private Dictionary<string, PrzedmiotLeczniczy> _wzorcePrzedmiotowLeczniczych;     // wzorce kompletnych przedmiotow leczniczych, klucz: typ przedmiotu, wartosc: struktura z informacjami
        private Dictionary<string, DanePrzedmiotu> _wzorcePrzedmiotow;     // wzorce wszystkich  przedmiotow, klucz: typ przedmiotu, wartosc: struktura z informacjami
        private List<SzansaNaZdarzenie> _wzorceChorobPierwotnych;           // list przejsc miedzy zdarzeniami z konfiguracji, tylko przejscia pierowtne (poczatek choroby)
        private List<SzansaNaZdarzenie> _wzorceChorobZaleznych;           // list przejsc miedzy zdarzeniami z konfiguracji, tylko przejscia zalezne (nowe objawy choroby)
        private List<Pacjent> _pacjenciSzpitalni;                // pacjenci chorzy obloznie
        private List<Pacjent> _pacjencjiWolni;                   // pacjenci przychodzacy
        private Dictionary<string, Receptura> _receptury;                 //wszystkie receptury dostepne w grze, klucz: nazwa receptury

        private static MenedzerZielarstwa _instancja;
        public static MenedzerZielarstwa Instancja
        {
            get
            {
                if (_instancja == null)
                    _instancja = new MenedzerZielarstwa();
                return _instancja;
            }
        } 
        private MenedzerZielarstwa ()
        {
            _wzorceZdarzen = new List<WzorzecZdarzeniaMedycznego>();
            _wzorceSubstancji = new List<Substancja>();
            _wzorcePrzedmiotowLeczniczych = new Dictionary<string, PrzedmiotLeczniczy>();
            _wzorcePrzedmiotow = new Dictionary<string, DanePrzedmiotu>();
            _pacjenciSzpitalni = new List<Pacjent>();
            _pacjencjiWolni = new List<Pacjent>();
            _wzorceChorobPierwotnych = new List<SzansaNaZdarzenie>();
            _wzorceChorobZaleznych = new List<SzansaNaZdarzenie>();
            _receptury = new Dictionary<string, Receptura>();
        }

        public void ZaladujDane()
        {
            if (_wzorceZdarzen.Count == 0)
            {
                try
                {
                    //zdarzenia   
                    IEnumerable<XElement> listaWezlowZdarzen = Dodatki.Funkcje.ZaladujZasobXMLJakoListeElementow("data/zdarzenia", "zdarzenia", null);
                    if (listaWezlowZdarzen != null)
                    {
                        foreach (XElement element in listaWezlowZdarzen)
                        {
                            WzorzecZdarzeniaMedycznego noweZdarzenie = new WzorzecZdarzeniaMedycznego();
                            noweZdarzenie.ZaladujDane(element);
                            _wzorceZdarzen.Add(noweZdarzenie);
                        }
                    }
                    //szanse 
                    IEnumerable<XElement> listaWezlowSzans = Dodatki.Funkcje.ZaladujZasobXMLJakoListeElementow("data/szanse", "szanse", null);
                    if (listaWezlowSzans != null)
                    {
                        foreach (XElement element in listaWezlowSzans)
                        {
                            SzansaNaZdarzenie nowaSzansaNaZdarzenie = new SzansaNaZdarzenie();
                            nowaSzansaNaZdarzenie.ZaladujDane(element);
                            if (nowaSzansaNaZdarzenie.TypZdarzeniaPoprzedniego == null)
                                _wzorceChorobPierwotnych.Add(nowaSzansaNaZdarzenie);
                            else
                                _wzorceChorobZaleznych.Add(nowaSzansaNaZdarzenie);
                        }
                    }
                    //substancje
                    IEnumerable<XElement> listaWezlowSubstancji = Dodatki.Funkcje.ZaladujZasobXMLJakoListeElementow("data/substancje", "substancje", null);
                    if (listaWezlowSzans != null)
                    {
                        foreach (XElement element in listaWezlowSubstancji)
                        {
                            Substancja nowaSubstancja = new Substancja();
                            nowaSubstancja.ZaladujDane(element);
                            _wzorceSubstancji.Add(nowaSubstancja);
                        }
                    }
                    //przedmioty lecznicze (ladowanie substancji musi tu byc skonczone poniewaz sa one uzywane do tworzenia klonow substancji aktywnych w przedmiotach)
                    IEnumerable<XElement> listaWezlowPrzedmiotowLeczniczych = Dodatki.Funkcje.ZaladujZasobXMLJakoListeElementow("data/przedmioty_lecznicze", "przedmioty_lecznicze", null);
                    if (listaWezlowPrzedmiotowLeczniczych != null)
                    {
                        foreach (XElement element in listaWezlowPrzedmiotowLeczniczych)
                        {
                            PrzedmiotLeczniczy nowyPrzedmiot = new PrzedmiotLeczniczy();
                            nowyPrzedmiot.ZaladujDane(element, _wzorceSubstancji);
                            _wzorcePrzedmiotowLeczniczych.Add(nowyPrzedmiot.Nazwa, nowyPrzedmiot);
                        }
                    }
                    //receptury
                    IEnumerable<XElement> listaWezlowReceptur = Dodatki.Funkcje.ZaladujZasobXMLJakoListeElementow("data/receptury", "receptury", null);
                    if (listaWezlowReceptur != null)
                    {
                        foreach (XElement element in listaWezlowReceptur)
                        {
                            Receptura nowaReceptura = new Receptura();
                            nowaReceptura.ZaladujDane(element);
                            _receptury.Add(nowaReceptura.Nazwa, nowaReceptura);
                        }
                    }
                    //przedmioty ogolnie
                    IEnumerable<XElement> listaWezlowPrzedmiotow = Dodatki.Funkcje.ZaladujZasobXMLJakoListeElementow("data/przedmioty", "przedmioty", null);
                    if (listaWezlowPrzedmiotow != null)
                    {
                        foreach (XElement element in listaWezlowPrzedmiotow)
                        {
                            DanePrzedmiotu nowyPrzedmiot = new DanePrzedmiotu();
                            nowyPrzedmiot.ZaladujDane(element);
                            _wzorcePrzedmiotow.Add(nowyPrzedmiot.Nazwa, nowyPrzedmiot);
                        }
                    }
                }
                catch (System.Exception wyjatek)
                {
                    Debug.LogError("Ogólny wyjątek: " + wyjatek.Message);
                }
            }
        }

        //tworzy nowe, losowe pierwotne zdarzenie medyczne (nowa chorobe), poniewaz bierze pod uwage prawdopodobienstwo zajscia chorob, moze zwrocic null oznaczajacy ze zadna nie zostala wylosowana
        public ZdarzenieMedyczne UtworzPierwotneZdarzenieMedyczne()
        {
            SzansaNaZdarzenie wylosowaneZdarzenie = null;
            foreach (SzansaNaZdarzenie szansa in _wzorceChorobPierwotnych)
                if (Random.Range(0, 1f) < szansa.Prawdopodobienstwo)
                    wylosowaneZdarzenie = szansa;
            if (wylosowaneZdarzenie != null)
            {
                float noweZaostrzenie = Random.Range(0.05f, 0.5f);
                ZdarzenieMedyczne noweZdarzenie = UtworzZdarzenieMedyczneNaPodstawieSzansy(wylosowaneZdarzenie, wylosowaneZdarzenie.LokalizacjaNastepna, 0, noweZaostrzenie);           
                noweZdarzenie.Sila = Random.Range(noweZdarzenie.MinimalnaSila + (noweZdarzenie.MinimalnaSila < 0.1f ? 0.1f : 0), noweZdarzenie.MaksymalnaSila);
                
                return noweZdarzenie;
            }
            else return null;
        }

        // Na zlecenie pacjenta wykonuje cogodzinna zmiane stanu zdarzenia medycznego.
        // Zdarzenie podane jako parametr moze zmienic swoj status, jesli jego sila spadnie do 0 - powinno byc usuniete
        // Zwracana wartosc to lista nowych zdarzen wyniklych z rozwoju choroby (moze byc pusta)
        public List<ZdarzenieMedyczne> PrzetworzStanZdarzeniaMedycznego(ZdarzenieMedyczne zdarzenie)
        {
            //proba wylosowania nowego zdarzenia
            List<ZdarzenieMedyczne> noweZdarzenia = new List<ZdarzenieMedyczne>();
            foreach (SzansaNaZdarzenie szansa in _wzorceChorobZaleznych)
            {
                if ( (szansa.LokalizacjaPoprzednia & zdarzenie.Lokalizacja) != 0 && szansa.TypZdarzeniaPoprzedniego == zdarzenie.Nazwa && Random.Range(0, 1f) < szansa.Prawdopodobienstwo)
                {
                    ZdarzenieMedyczne noweZdarzenie = UtworzZdarzenieMedyczneNaPodstawieSzansy(szansa, szansa.LokalizacjaNastepna == CzescCiala.Dowolna ? zdarzenie.Lokalizacja : szansa.LokalizacjaNastepna,  zdarzenie.Sila, zdarzenie.Zaostrzenie);
                    noweZdarzenia.Add(noweZdarzenie);
                }
            }
            //zmiana stanu istniejacego zdarzenia
            zdarzenie.PrzetworzGodzinowo();
            return noweZdarzenia;
        }
        //próbuje dopasować wzorzec receptury do podanego typu i jeśli mu się uda - zwraca ją
        public Receptura ZnajdzRecepture(string nazwa)
        {
            if (_receptury.ContainsKey(nazwa))
                return _receptury[nazwa];
            else return null;
        }

        //próbuje dopasować wzorzec przedmiotu leczniczego do podanego typu i jeśli mu się uda - tworzy instancję klasy PrzedmiotLeczniczy i ją zwraca
        public PrzedmiotLeczniczy UtworzPrzedmiotLeczniczy(string szukanyTyp)
        {
            if (_wzorcePrzedmiotowLeczniczych.ContainsKey(szukanyTyp))
                return new PrzedmiotLeczniczy(_wzorcePrzedmiotowLeczniczych[szukanyTyp]);
            return null;
        }
        
        //próbuje dopasować wzorzec przedmiotu do podanego typu i jeśli mu się uda - zwraca go
        public DanePrzedmiotu ZnajdzPrzedmiot(string szukanyTyp)
        {
            if (_wzorcePrzedmiotow.ContainsKey(szukanyTyp))
                return _wzorcePrzedmiotow[szukanyTyp];
            return null;
        }
        //zwraca Nazwe losowo wybranego przedmiotu
        public string WylosujPrzedmiot()
        {
            int losowyIndeks = UnityEngine.Random.Range(0, _wzorcePrzedmiotow.Keys.Count);
            int aktualnyIndeks = 0;
            foreach (string nazwa in _wzorcePrzedmiotow.Keys)
		if (++aktualnyIndeks > losowyIndeks)
                    return nazwa;
            return null;
        }
        //tworzy ZdarzenieMedyczne na podstawie typu
        public ZdarzenieMedyczne UtworzZdarzenieMedyczneNaPodstawieTypu(string nazwaZdarzenia, CzescCiala lokalizacjaZdarzenia, float sila, float zaostrzenie)
        {
            WzorzecZdarzeniaMedycznego nowyWzorzec = null;
            foreach (WzorzecZdarzeniaMedycznego wzorzec in _wzorceZdarzen)
                if (wzorzec.Nazwa == nazwaZdarzenia)
                    nowyWzorzec = wzorzec;
            if (nowyWzorzec == null)
            {
                Debug.LogError("Nie można znalezc wzorca zdarzenia medycznego " + nazwaZdarzenia);
                return null;
            }
            return UtworzZdarzenieMedyczneNaPodstawieWzorca(nowyWzorzec, lokalizacjaZdarzenia, sila, zaostrzenie);
        }


        //tworzy ZdarzenieMedyczne na podstawie szansy
        private ZdarzenieMedyczne UtworzZdarzenieMedyczneNaPodstawieSzansy(SzansaNaZdarzenie szansaZdarzenia, CzescCiala lokalizacjaZdarzenia, float sila, float zaostrzenie)
        {
            WzorzecZdarzeniaMedycznego nowyWzorzec = null;
            foreach (WzorzecZdarzeniaMedycznego wzorzec in _wzorceZdarzen)
                if (wzorzec.Nazwa == szansaZdarzenia.TypZdarzeniaNastepnego)
                    nowyWzorzec = wzorzec;
            if (nowyWzorzec == null)
            {
                Debug.LogError("Nie można znalezc wzorca zdarzenia medycznego " + szansaZdarzenia.TypZdarzeniaNastepnego);
                return null;
            }
            return UtworzZdarzenieMedyczneNaPodstawieWzorca(nowyWzorzec, lokalizacjaZdarzenia, sila, zaostrzenie);
        }
        private ZdarzenieMedyczne UtworzZdarzenieMedyczneNaPodstawieWzorca(WzorzecZdarzeniaMedycznego nowyWzorzec, CzescCiala lokalizacjaZdarzenia, float sila, float zaostrzenie)
        {
            ZdarzenieMedyczne zdarzenie = new ZdarzenieMedyczne(nowyWzorzec);
            zdarzenie.Lokalizacja = lokalizacjaZdarzenia;
            zdarzenie.Sila = sila;
            zdarzenie.Zaostrzenie = zaostrzenie;
            return zdarzenie;
        }
    }
}