﻿// **** Autor: Jacek Ross - games@ejr.com.pl
// **** Plik jest czescia projektu SymulatorZielarza stworzonego na potrzeby ksiazki "Unity i C#. Praktyka programowania gier" wyd. Helion 2020 oraz czescia kodu gry SymulatorZielarza wydanej w serwisie Steam, wiecej info: http://ejr.com.pl
// **** Dozwolone użycie pod licencją CC0 1.0 (public domain). 
// **** Jeżeli modyfikujesz niniejszy plik - umiesc w nim informacje o tym, ze zawartosc odbiega od oryginalu albo usun informacje o autorze

// **** Author: Jacek Ross - games@ejr.com.pl
// **** This file is a part of SymulatorZielarza project created for book "Unity i C#. Praktyka programowania gier" published by Helion 2020 and a part of source of game SymulatorZielarza published on Steam, more info: http://ejr.com.pl
// **** Usage permission under CC0 1.0 license (public domain). 
// **** If you modified this file - put here an information about that the content of file is modified and diffrent than the original, or delete info about original author

using System;
using UnityEngine;

namespace ZielarzSilnik
{
    public class GeneratorObiektow : MonoBehaviour
    {
        public const float CZASOBLICZEN = 0.39f;        //jak często sprawdzać odległość do gracza [s.]
        public const float MAKSYMALNAWIDOCZNOSCGENERACJI = 40;      //w jakiej odleglosci startowac generacje [m.]
        public string[] ObiektyDozwoloneDoGeneracji;        //zawiera obiekty dozwolone do utworzenia
        public int[] Prawdopodobienstwa;                    //prawdopodobienstwo utworzenia obiektów, musi mieć tyle samo elementów co ObiektyDozwoloneDoGeneracji
        public float PozycjaY = 0.3f;                       // jak wysoko tworzyć obiekt nad ziemię
        public bool ZmieniajZawszeZiarno = false;           // ustawione na true będzie zawsze zmieniać ziarno losowości znacznikiem czasu i losować za każdym razem coś innego
        public bool AutomatycznieGeneruj = true;            // true oznacza że w pierwszym Update nastąpi generacja, false - że musi być wywołana kodem

        private bool _pierwszyUpdate;
        private float _licznikCzasu;
        private bool _wykonanoGeneracje;
        public void Generuj()
        {
            if (!_wykonanoGeneracje)
            {
                _wykonanoGeneracje = true;
                InicjujZiarno();
                string obiektDoGeneracji = "";
                string[] obiektydoGeneracji = new string[ObiektyDozwoloneDoGeneracji.Length];
                for (int i = 0; i < ObiektyDozwoloneDoGeneracji.Length; i++)
                    obiektydoGeneracji[i] = ObiektyDozwoloneDoGeneracji[i];
                int liczbaLosowa = UnityEngine.Random.Range(0, 100);
                int sumaLosowa = 0;
                for (int i = 0; i < obiektydoGeneracji.Length && obiektDoGeneracji == ""; i++)
                {
                    sumaLosowa += Prawdopodobienstwa[i];
                    if (sumaLosowa > liczbaLosowa)
                        obiektDoGeneracji = ObiektyDozwoloneDoGeneracji[i];
                }
                if (obiektDoGeneracji != "")
                {
                    Vector3 nowaPozycja = new Vector3(transform.position.x, transform.position.y + PozycjaY, transform.position.z);
                    WewnetrznaGeneracja(obiektDoGeneracji, nowaPozycja);
                }
                gameObject.SetActive(false);
                MenedzerGry.InstancjaMenedzeraGry.ZapiszZmienna("generator_" + UnikalnyID().ToString(), -1);
            }
        }
              
        private void WewnetrznaGeneracja(string nazwaObiektu, Vector3 nowaPozycja)
        {
            if (nazwaObiektu == null || nazwaObiektu == "")
                return;
            GameObject stworzonyObiekt = MenedzerAktywnychPrzedmiotow.Instancja.UtworzNowyAktywnyPrzedmiot(nazwaObiektu, nowaPozycja);           
            stworzonyObiekt.SetActive(true);
        }
        private void InicjujZiarno()
        {
            if (ZmieniajZawszeZiarno)
            {
                UnityEngine.Random.InitState(DateTime.Now.Millisecond);
            }
            else
            {
                //inicjuj ziarno liczba okreslona na podstawie pozycji generatora
                UnityEngine.Random.InitState(UnikalnyID());
            }
        }
        private int UnikalnyID()
        {
            return (int)(100 * transform.position.x * 1024 + 100 * transform.position.z); 
        }
        private void Update()
        {
            _licznikCzasu -= Time.deltaTime;
            if (_licznikCzasu < 0 && !_wykonanoGeneracje)
            {
                _licznikCzasu = CZASOBLICZEN;
                float playerWorldX = Camera.main.transform.position.x;
                float playerWorldZ = Camera.main.transform.position.z;
                bool czyPoiwnienBycWidoczny = transform.position.x > playerWorldX - MAKSYMALNAWIDOCZNOSCGENERACJI && transform.position.x < playerWorldX + MAKSYMALNAWIDOCZNOSCGENERACJI && transform.position.z > playerWorldZ - MAKSYMALNAWIDOCZNOSCGENERACJI && transform.position.z < playerWorldZ + MAKSYMALNAWIDOCZNOSCGENERACJI;
                if (czyPoiwnienBycWidoczny)
                {

                    if (_pierwszyUpdate)
                    {
                        int status = MenedzerGry.InstancjaMenedzeraGry.OdczytajZmiennaInt("generator_" + UnikalnyID().ToString());
                        if (status == -1)
                            gameObject.SetActive(false);
                        _pierwszyUpdate = false;
                    }
                    else
                    {
                        if (AutomatycznieGeneruj)
                            Generuj();
                    }
                }
            }
        }
        private void Start()
        {
            if (ObiektyDozwoloneDoGeneracji.Length != Prawdopodobienstwa.Length)
                Debug.LogError("Nieprawidłowa wielkość tablic generatora w " + transform.position.ToString());
            _pierwszyUpdate = true;
            _licznikCzasu = CZASOBLICZEN;
            _wykonanoGeneracje = false;
            if(GetComponent<Renderer>() != null)
                GetComponent<Renderer>().enabled = false;
            if (GetComponent<Collider>() != null)
                GetComponent<Collider>().enabled = false;
            
        }
    }
}
